// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * The application identifier.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The version of the application to deploy.
     */
    public val applicationVersion: kotlin.Int = requireNotNull(builder.applicationVersion) { "A non-null value must be provided for applicationVersion" }
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a deployment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identifier of the runtime environment where you want to deploy this application.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("applicationId=$applicationId,")
        append("applicationVersion=$applicationVersion,")
        append("clientToken=$clientToken,")
        append("environmentId=$environmentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId.hashCode()
        result = 31 * result + (applicationVersion)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (environmentId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (applicationId != other.applicationId) return false
        if (applicationVersion != other.applicationVersion) return false
        if (clientToken != other.clientToken) return false
        if (environmentId != other.environmentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application identifier.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The version of the application to deploy.
         */
        public var applicationVersion: kotlin.Int? = null
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a deployment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The identifier of the runtime environment where you want to deploy this application.
         */
        public var environmentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.CreateDeploymentRequest) : this() {
            this.applicationId = x.applicationId
            this.applicationVersion = x.applicationVersion
            this.clientToken = x.clientToken
            this.environmentId = x.environmentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (applicationVersion == null) applicationVersion = 0
            if (environmentId == null) environmentId = ""
            return this
        }
    }
}
