// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A batch job identifier in which the batch jobs to run are identified by an Amazon S3 location.
 */
public class S3BatchJobIdentifier private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket that contains the batch job definitions.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Identifies the batch job definition. This identifier can also point to any batch job definition that already exists in the application or to one of the batch job definitions within the directory that is specified in `keyPrefix`.
     */
    public val identifier: aws.sdk.kotlin.services.m2.model.JobIdentifier? = builder.identifier
    /**
     * The key prefix that specifies the path to the folder in the S3 bucket that has the batch job definitions.
     */
    public val keyPrefix: kotlin.String? = builder.keyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.S3BatchJobIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BatchJobIdentifier(")
        append("bucket=$bucket,")
        append("identifier=$identifier,")
        append("keyPrefix=$keyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BatchJobIdentifier

        if (bucket != other.bucket) return false
        if (identifier != other.identifier) return false
        if (keyPrefix != other.keyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.S3BatchJobIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket that contains the batch job definitions.
         */
        public var bucket: kotlin.String? = null
        /**
         * Identifies the batch job definition. This identifier can also point to any batch job definition that already exists in the application or to one of the batch job definitions within the directory that is specified in `keyPrefix`.
         */
        public var identifier: aws.sdk.kotlin.services.m2.model.JobIdentifier? = null
        /**
         * The key prefix that specifies the path to the folder in the S3 bucket that has the batch job definitions.
         */
        public var keyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.S3BatchJobIdentifier) : this() {
            this.bucket = x.bucket
            this.identifier = x.identifier
            this.keyPrefix = x.keyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.S3BatchJobIdentifier = S3BatchJobIdentifier(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            return this
        }
    }
}
