// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetApplicationVersionResponse private constructor(builder: Builder) {
    /**
     * The specific version of the application.
     */
    public val applicationVersion: kotlin.Int = requireNotNull(builder.applicationVersion) { "A non-null value must be provided for applicationVersion" }
    /**
     * The timestamp when the application version was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The content of the application definition. This is a JSON object that contains the resource configuration and definitions that identify an application.
     */
    public val definitionContent: kotlin.String = requireNotNull(builder.definitionContent) { "A non-null value must be provided for definitionContent" }
    /**
     * The application description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the application version.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the application version.
     */
    public val status: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.GetApplicationVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetApplicationVersionResponse(")
        append("applicationVersion=$applicationVersion,")
        append("creationTime=$creationTime,")
        append("definitionContent=$definitionContent,")
        append("description=$description,")
        append("name=$name,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationVersion
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (definitionContent.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetApplicationVersionResponse

        if (applicationVersion != other.applicationVersion) return false
        if (creationTime != other.creationTime) return false
        if (definitionContent != other.definitionContent) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.GetApplicationVersionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The specific version of the application.
         */
        public var applicationVersion: kotlin.Int? = null
        /**
         * The timestamp when the application version was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The content of the application definition. This is a JSON object that contains the resource configuration and definitions that identify an application.
         */
        public var definitionContent: kotlin.String? = null
        /**
         * The application description.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the application version.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the application version.
         */
        public var status: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.GetApplicationVersionResponse) : this() {
            this.applicationVersion = x.applicationVersion
            this.creationTime = x.creationTime
            this.definitionContent = x.definitionContent
            this.description = x.description
            this.name = x.name
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.GetApplicationVersionResponse = GetApplicationVersionResponse(this)

        internal fun correctErrors(): Builder {
            if (applicationVersion == null) applicationVersion = 0
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (definitionContent == null) definitionContent = ""
            if (name == null) name = ""
            if (status == null) status = ApplicationVersionLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
