// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application version summary.
 */
public class ApplicationVersionSummary private constructor(builder: Builder) {
    /**
     * The application version.
     */
    public val applicationVersion: kotlin.Int = requireNotNull(builder.applicationVersion) { "A non-null value must be provided for applicationVersion" }
    /**
     * The timestamp when the application version was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The status of the application.
     */
    public val status: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationVersionSummary(")
        append("applicationVersion=$applicationVersion,")
        append("creationTime=$creationTime,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationVersion
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationVersionSummary

        if (applicationVersion != other.applicationVersion) return false
        if (creationTime != other.creationTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application version.
         */
        public var applicationVersion: kotlin.Int? = null
        /**
         * The timestamp when the application version was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the application.
         */
        public var status: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary) : this() {
            this.applicationVersion = x.applicationVersion
            this.creationTime = x.creationTime
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary = ApplicationVersionSummary(this)

        internal fun correctErrors(): Builder {
            if (applicationVersion == null) applicationVersion = 0
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (status == null) status = ApplicationVersionLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
