// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.ApplicationLifecycle
import aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary
import aws.sdk.kotlin.services.m2.model.DeployedVersionSummary
import aws.sdk.kotlin.services.m2.model.EngineType
import aws.sdk.kotlin.services.m2.model.GetApplicationResponse
import aws.sdk.kotlin.services.m2.model.LogGroupSummary
import aws.sdk.kotlin.services.m2.model.M2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetApplicationOperationDeserializer: HttpDeserializer.NonStreaming<GetApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetApplicationError(context, call, payload)
        }
        val builder = GetApplicationResponse.Builder()

        if (payload != null) {
            deserializeGetApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw M2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> M2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetApplicationOperationBody(builder: GetApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationArn"))
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DEPLOYEDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deployedVersion"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENGINETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineType"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val LASTSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStartTime"))
    val LATESTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestVersion"))
    val LISTENERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("listenerArns"))
    val LISTENERPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("listenerPorts"))
    val LOADBALANCERDNSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("loadBalancerDnsName"))
    val LOGGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("logGroups"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TARGETGROUPARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetGroupArns"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONARN_DESCRIPTOR)
        field(APPLICATIONID_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DEPLOYEDVERSION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINETYPE_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTSTARTTIME_DESCRIPTOR)
        field(LATESTVERSION_DESCRIPTOR)
        field(LISTENERARNS_DESCRIPTOR)
        field(LISTENERPORTS_DESCRIPTOR)
        field(LOADBALANCERDNSNAME_DESCRIPTOR)
        field(LOGGROUPS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETGROUPARNS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONARN_DESCRIPTOR.index -> builder.applicationArn = deserializeString()
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEPLOYEDVERSION_DESCRIPTOR.index -> builder.deployedVersion = deserializeDeployedVersionSummaryDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENGINETYPE_DESCRIPTOR.index -> builder.engineType = deserializeString().let { EngineType.fromValue(it) }
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTSTARTTIME_DESCRIPTOR.index -> builder.lastStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LATESTVERSION_DESCRIPTOR.index -> builder.latestVersion = deserializeApplicationVersionSummaryDocument(deserializer)
                LISTENERARNS_DESCRIPTOR.index -> builder.listenerArns =
                    deserializer.deserializeList(LISTENERARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LISTENERPORTS_DESCRIPTOR.index -> builder.listenerPorts =
                    deserializer.deserializeList(LISTENERPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Int>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInt() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOADBALANCERDNSNAME_DESCRIPTOR.index -> builder.loadBalancerDnsName = deserializeString()
                LOGGROUPS_DESCRIPTOR.index -> builder.logGroups =
                    deserializer.deserializeList(LOGGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<LogGroupSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLogGroupSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ApplicationLifecycle.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TARGETGROUPARNS_DESCRIPTOR.index -> builder.targetGroupArns =
                    deserializer.deserializeList(TARGETGROUPARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
