// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.serde

import aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.m2.model.EngineType
import aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig
import aws.sdk.kotlin.services.m2.model.StorageConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateEnvironmentOperationSerializer: HttpSerializer.NonStreaming<CreateEnvironmentRequest> {
    override fun serialize(context: ExecutionContext, input: CreateEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/environments"
        }

        val payload = serializeCreateEnvironmentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateEnvironmentOperationBody(context: ExecutionContext, input: CreateEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENGINETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineType"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("engineVersion"))
    val HIGHAVAILABILITYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("highAvailabilityConfig"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("preferredMaintenanceWindow"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publiclyAccessible"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroupIds"))
    val STORAGECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("storageConfigurations"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINETYPE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(HIGHAVAILABILITYCONFIG_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(STORAGECONFIGURATIONS_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        field(ENGINETYPE_DESCRIPTOR, input.engineType.value)
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.highAvailabilityConfig?.let { field(HIGHAVAILABILITYCONFIG_DESCRIPTOR, it, ::serializeHighAvailabilityConfigDocument) }
        field(INSTANCETYPE_DESCRIPTOR, input.instanceType)
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        field(NAME_DESCRIPTOR, input.name)
        input.preferredMaintenanceWindow?.let { field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR, it) }
        if (input.publiclyAccessible != false) field(PUBLICLYACCESSIBLE_DESCRIPTOR, input.publiclyAccessible)
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.storageConfigurations != null) {
            listField(STORAGECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.storageConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeStorageConfigurationDocument))
                }
            }
        }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
