// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * Indicates whether to update the runtime environment during the maintenance window. The default is false. Currently, Amazon Web Services Mainframe Modernization accepts the `engineVersion` parameter only if `applyDuringMaintenanceWindow` is true. If any parameter other than `engineVersion` is provided in `UpdateEnvironmentRequest`, it will fail if `applyDuringMaintenanceWindow` is set to true.
     */
    public val applyDuringMaintenanceWindow: kotlin.Boolean = builder.applyDuringMaintenanceWindow
    /**
     * The desired capacity for the runtime environment to update. The minimum possible value is 0 and the maximum is 100.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The version of the runtime engine for the runtime environment.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The unique identifier of the runtime environment that you want to update.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * Forces the updates on the environment. This option is needed if the applications in the environment are not stopped or if there are ongoing application-related activities in the environment.
     *
     * If you use this option, be aware that it could lead to data corruption in the applications, and that you might need to perform repair and recovery procedures for the applications.
     *
     * This option is not needed if the attribute being updated is `preferredMaintenanceWindow`.
     */
    public val forceUpdate: kotlin.Boolean = builder.forceUpdate
    /**
     * The instance type for the runtime environment to update.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. The following two examples are valid maintenance windows: `sun:23:45-mon:00:15` or `sat:01:00-sat:03:00`.
     *
     * If you do not provide a value, a random system-generated value will be assigned.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.UpdateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentRequest(")
        append("applyDuringMaintenanceWindow=$applyDuringMaintenanceWindow,")
        append("desiredCapacity=$desiredCapacity,")
        append("engineVersion=$engineVersion,")
        append("environmentId=$environmentId,")
        append("forceUpdate=$forceUpdate,")
        append("instanceType=$instanceType,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyDuringMaintenanceWindow.hashCode()
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (forceUpdate.hashCode())
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentRequest

        if (applyDuringMaintenanceWindow != other.applyDuringMaintenanceWindow) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (engineVersion != other.engineVersion) return false
        if (environmentId != other.environmentId) return false
        if (forceUpdate != other.forceUpdate) return false
        if (instanceType != other.instanceType) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.UpdateEnvironmentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether to update the runtime environment during the maintenance window. The default is false. Currently, Amazon Web Services Mainframe Modernization accepts the `engineVersion` parameter only if `applyDuringMaintenanceWindow` is true. If any parameter other than `engineVersion` is provided in `UpdateEnvironmentRequest`, it will fail if `applyDuringMaintenanceWindow` is set to true.
         */
        public var applyDuringMaintenanceWindow: kotlin.Boolean = false
        /**
         * The desired capacity for the runtime environment to update. The minimum possible value is 0 and the maximum is 100.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The version of the runtime engine for the runtime environment.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The unique identifier of the runtime environment that you want to update.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Forces the updates on the environment. This option is needed if the applications in the environment are not stopped or if there are ongoing application-related activities in the environment.
         *
         * If you use this option, be aware that it could lead to data corruption in the applications, and that you might need to perform repair and recovery procedures for the applications.
         *
         * This option is not needed if the attribute being updated is `preferredMaintenanceWindow`.
         */
        public var forceUpdate: kotlin.Boolean = false
        /**
         * The instance type for the runtime environment to update.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. The following two examples are valid maintenance windows: `sun:23:45-mon:00:15` or `sat:01:00-sat:03:00`.
         *
         * If you do not provide a value, a random system-generated value will be assigned.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.UpdateEnvironmentRequest) : this() {
            this.applyDuringMaintenanceWindow = x.applyDuringMaintenanceWindow
            this.desiredCapacity = x.desiredCapacity
            this.engineVersion = x.engineVersion
            this.environmentId = x.environmentId
            this.forceUpdate = x.forceUpdate
            this.instanceType = x.instanceType
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.UpdateEnvironmentRequest = UpdateEnvironmentRequest(this)

        internal fun correctErrors(): Builder {
            if (environmentId == null) environmentId = ""
            return this
        }
    }
}
