// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetEnvironmentResponse private constructor(builder: Builder) {
    /**
     * The number of instances included in the runtime environment. A standalone runtime environment has a maximum of one instance. Currently, a high availability runtime environment has a maximum of two instances.
     */
    public val actualCapacity: kotlin.Int? = builder.actualCapacity
    /**
     * The timestamp when the runtime environment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The description of the runtime environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The target platform for the runtime environment.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The version of the runtime engine.
     */
    public val engineVersion: kotlin.String = requireNotNull(builder.engineVersion) { "A non-null value must be provided for engineVersion" }
    /**
     * The Amazon Resource Name (ARN) of the runtime environment.
     */
    public val environmentArn: kotlin.String = requireNotNull(builder.environmentArn) { "A non-null value must be provided for environmentArn" }
    /**
     * The unique identifier of the runtime environment.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * The desired capacity of the high availability configuration for the runtime environment.
     */
    public val highAvailabilityConfig: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig? = builder.highAvailabilityConfig
    /**
     * The type of instance underlying the runtime environment.
     */
    public val instanceType: kotlin.String = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }
    /**
     * The identifier of a customer managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
     */
    public val loadBalancerArn: kotlin.String? = builder.loadBalancerArn
    /**
     * The name of the runtime environment. Must be unique within the account.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Indicates the pending maintenance scheduled on this environment.
     */
    public val pendingMaintenance: aws.sdk.kotlin.services.m2.model.PendingMaintenance? = builder.pendingMaintenance
    /**
     * The maintenance window for the runtime environment. If you don't provide a value for the maintenance window, the service assigns a random value.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Whether applications running in this runtime environment are publicly accessible.
     */
    public val publiclyAccessible: kotlin.Boolean = builder.publiclyAccessible
    /**
     * The unique identifiers of the security groups assigned to this runtime environment.
     */
    public val securityGroupIds: List<String> = requireNotNull(builder.securityGroupIds) { "A non-null value must be provided for securityGroupIds" }
    /**
     * The status of the runtime environment.
     */
    public val status: aws.sdk.kotlin.services.m2.model.EnvironmentLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The storage configurations defined for the runtime environment.
     */
    public val storageConfigurations: List<StorageConfiguration>? = builder.storageConfigurations
    /**
     * The unique identifiers of the subnets assigned to this runtime environment.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * The tags defined for this runtime environment.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The unique identifier for the VPC used with this runtime environment.
     */
    public val vpcId: kotlin.String = requireNotNull(builder.vpcId) { "A non-null value must be provided for vpcId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEnvironmentResponse(")
        append("actualCapacity=$actualCapacity,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("environmentArn=$environmentArn,")
        append("environmentId=$environmentId,")
        append("highAvailabilityConfig=$highAvailabilityConfig,")
        append("instanceType=$instanceType,")
        append("kmsKeyId=$kmsKeyId,")
        append("loadBalancerArn=$loadBalancerArn,")
        append("name=$name,")
        append("pendingMaintenance=$pendingMaintenance,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroupIds=$securityGroupIds,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("storageConfigurations=$storageConfigurations,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualCapacity ?: 0
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (engineVersion.hashCode())
        result = 31 * result + (environmentArn.hashCode())
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (highAvailabilityConfig?.hashCode() ?: 0)
        result = 31 * result + (instanceType.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (pendingMaintenance?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (securityGroupIds.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (storageConfigurations?.hashCode() ?: 0)
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEnvironmentResponse

        if (actualCapacity != other.actualCapacity) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (environmentArn != other.environmentArn) return false
        if (environmentId != other.environmentId) return false
        if (highAvailabilityConfig != other.highAvailabilityConfig) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (loadBalancerArn != other.loadBalancerArn) return false
        if (name != other.name) return false
        if (pendingMaintenance != other.pendingMaintenance) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (storageConfigurations != other.storageConfigurations) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of instances included in the runtime environment. A standalone runtime environment has a maximum of one instance. Currently, a high availability runtime environment has a maximum of two instances.
         */
        public var actualCapacity: kotlin.Int? = null
        /**
         * The timestamp when the runtime environment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the runtime environment.
         */
        public var description: kotlin.String? = null
        /**
         * The target platform for the runtime environment.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The version of the runtime engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the runtime environment.
         */
        public var environmentArn: kotlin.String? = null
        /**
         * The unique identifier of the runtime environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The desired capacity of the high availability configuration for the runtime environment.
         */
        public var highAvailabilityConfig: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig? = null
        /**
         * The type of instance underlying the runtime environment.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The identifier of a customer managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.
         */
        public var loadBalancerArn: kotlin.String? = null
        /**
         * The name of the runtime environment. Must be unique within the account.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the pending maintenance scheduled on this environment.
         */
        public var pendingMaintenance: aws.sdk.kotlin.services.m2.model.PendingMaintenance? = null
        /**
         * The maintenance window for the runtime environment. If you don't provide a value for the maintenance window, the service assigns a random value.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Whether applications running in this runtime environment are publicly accessible.
         */
        public var publiclyAccessible: kotlin.Boolean = false
        /**
         * The unique identifiers of the security groups assigned to this runtime environment.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The status of the runtime environment.
         */
        public var status: aws.sdk.kotlin.services.m2.model.EnvironmentLifecycle? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The storage configurations defined for the runtime environment.
         */
        public var storageConfigurations: List<StorageConfiguration>? = null
        /**
         * The unique identifiers of the subnets assigned to this runtime environment.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags defined for this runtime environment.
         */
        public var tags: Map<String, String>? = null
        /**
         * The unique identifier for the VPC used with this runtime environment.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse) : this() {
            this.actualCapacity = x.actualCapacity
            this.creationTime = x.creationTime
            this.description = x.description
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.environmentArn = x.environmentArn
            this.environmentId = x.environmentId
            this.highAvailabilityConfig = x.highAvailabilityConfig
            this.instanceType = x.instanceType
            this.kmsKeyId = x.kmsKeyId
            this.loadBalancerArn = x.loadBalancerArn
            this.name = x.name
            this.pendingMaintenance = x.pendingMaintenance
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroupIds = x.securityGroupIds
            this.status = x.status
            this.statusReason = x.statusReason
            this.storageConfigurations = x.storageConfigurations
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.GetEnvironmentResponse = GetEnvironmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig] inside the given [block]
         */
        public fun highAvailabilityConfig(block: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig.Builder.() -> kotlin.Unit) {
            this.highAvailabilityConfig = aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.PendingMaintenance] inside the given [block]
         */
        public fun pendingMaintenance(block: aws.sdk.kotlin.services.m2.model.PendingMaintenance.Builder.() -> kotlin.Unit) {
            this.pendingMaintenance = aws.sdk.kotlin.services.m2.model.PendingMaintenance.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (engineVersion == null) engineVersion = ""
            if (environmentArn == null) environmentArn = ""
            if (environmentId == null) environmentId = ""
            if (instanceType == null) instanceType = ""
            if (name == null) name = ""
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (status == null) status = EnvironmentLifecycle.SdkUnknown("no value provided")
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcId == null) vpcId = ""
            return this
        }
    }
}
