// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetDeploymentResponse private constructor(builder: Builder) {
    /**
     * The unique identifier of the application.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The application version.
     */
    public val applicationVersion: kotlin.Int = requireNotNull(builder.applicationVersion) { "A non-null value must be provided for applicationVersion" }
    /**
     * The timestamp when the deployment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The unique identifier of the deployment.
     */
    public val deploymentId: kotlin.String = requireNotNull(builder.deploymentId) { "A non-null value must be provided for deploymentId" }
    /**
     * The unique identifier of the runtime environment.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * The status of the deployment.
     */
    public val status: aws.sdk.kotlin.services.m2.model.DeploymentLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.GetDeploymentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentResponse(")
        append("applicationId=$applicationId,")
        append("applicationVersion=$applicationVersion,")
        append("creationTime=$creationTime,")
        append("deploymentId=$deploymentId,")
        append("environmentId=$environmentId,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId.hashCode()
        result = 31 * result + (applicationVersion)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (deploymentId.hashCode())
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDeploymentResponse

        if (applicationId != other.applicationId) return false
        if (applicationVersion != other.applicationVersion) return false
        if (creationTime != other.creationTime) return false
        if (deploymentId != other.deploymentId) return false
        if (environmentId != other.environmentId) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.GetDeploymentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The application version.
         */
        public var applicationVersion: kotlin.Int? = null
        /**
         * The timestamp when the deployment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The unique identifier of the runtime environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The status of the deployment.
         */
        public var status: aws.sdk.kotlin.services.m2.model.DeploymentLifecycle? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.GetDeploymentResponse) : this() {
            this.applicationId = x.applicationId
            this.applicationVersion = x.applicationVersion
            this.creationTime = x.creationTime
            this.deploymentId = x.deploymentId
            this.environmentId = x.environmentId
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.GetDeploymentResponse = GetDeploymentResponse(this)

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (applicationVersion == null) applicationVersion = 0
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (deploymentId == null) deploymentId = ""
            if (environmentId == null) environmentId = ""
            if (status == null) status = DeploymentLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
