// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetBatchJobExecutionResponse private constructor(builder: Builder) {
    /**
     * The identifier of the application.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The unique identifier of this batch job.
     */
    public val batchJobIdentifier: aws.sdk.kotlin.services.m2.model.BatchJobIdentifier? = builder.batchJobIdentifier
    /**
     * The timestamp when the batch job execution ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The unique identifier for this batch job execution.
     */
    public val executionId: kotlin.String = requireNotNull(builder.executionId) { "A non-null value must be provided for executionId" }
    /**
     * The unique identifier for this batch job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The name of this batch job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The restart steps information for the most recent restart operation.
     */
    public val jobStepRestartMarker: aws.sdk.kotlin.services.m2.model.JobStepRestartMarker? = builder.jobStepRestartMarker
    /**
     * The type of job.
     */
    public val jobType: aws.sdk.kotlin.services.m2.model.BatchJobType? = builder.jobType
    /**
     * The user for the job.
     */
    public val jobUser: kotlin.String? = builder.jobUser
    /**
     * The batch job return code from either the Blu Age or Micro Focus runtime engines. For more information, see [Batch return codes](https://www.ibm.com/docs/en/was/8.5.5?topic=model-batch-return-codes) in the *IBM WebSphere Application Server* documentation.
     */
    public val returnCode: kotlin.String? = builder.returnCode
    /**
     * The timestamp when the batch job execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The status of the batch job execution.
     */
    public val status: aws.sdk.kotlin.services.m2.model.BatchJobExecutionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBatchJobExecutionResponse(")
        append("applicationId=$applicationId,")
        append("batchJobIdentifier=$batchJobIdentifier,")
        append("endTime=$endTime,")
        append("executionId=$executionId,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStepRestartMarker=$jobStepRestartMarker,")
        append("jobType=$jobType,")
        append("jobUser=$jobUser,")
        append("returnCode=$returnCode,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId.hashCode()
        result = 31 * result + (batchJobIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (executionId.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStepRestartMarker?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (jobUser?.hashCode() ?: 0)
        result = 31 * result + (returnCode?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBatchJobExecutionResponse

        if (applicationId != other.applicationId) return false
        if (batchJobIdentifier != other.batchJobIdentifier) return false
        if (endTime != other.endTime) return false
        if (executionId != other.executionId) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStepRestartMarker != other.jobStepRestartMarker) return false
        if (jobType != other.jobType) return false
        if (jobUser != other.jobUser) return false
        if (returnCode != other.returnCode) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The unique identifier of this batch job.
         */
        public var batchJobIdentifier: aws.sdk.kotlin.services.m2.model.BatchJobIdentifier? = null
        /**
         * The timestamp when the batch job execution ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for this batch job execution.
         */
        public var executionId: kotlin.String? = null
        /**
         * The unique identifier for this batch job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The name of this batch job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The restart steps information for the most recent restart operation.
         */
        public var jobStepRestartMarker: aws.sdk.kotlin.services.m2.model.JobStepRestartMarker? = null
        /**
         * The type of job.
         */
        public var jobType: aws.sdk.kotlin.services.m2.model.BatchJobType? = null
        /**
         * The user for the job.
         */
        public var jobUser: kotlin.String? = null
        /**
         * The batch job return code from either the Blu Age or Micro Focus runtime engines. For more information, see [Batch return codes](https://www.ibm.com/docs/en/was/8.5.5?topic=model-batch-return-codes) in the *IBM WebSphere Application Server* documentation.
         */
        public var returnCode: kotlin.String? = null
        /**
         * The timestamp when the batch job execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the batch job execution.
         */
        public var status: aws.sdk.kotlin.services.m2.model.BatchJobExecutionStatus? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse) : this() {
            this.applicationId = x.applicationId
            this.batchJobIdentifier = x.batchJobIdentifier
            this.endTime = x.endTime
            this.executionId = x.executionId
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStepRestartMarker = x.jobStepRestartMarker
            this.jobType = x.jobType
            this.jobUser = x.jobUser
            this.returnCode = x.returnCode
            this.startTime = x.startTime
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.GetBatchJobExecutionResponse = GetBatchJobExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.JobStepRestartMarker] inside the given [block]
         */
        public fun jobStepRestartMarker(block: aws.sdk.kotlin.services.m2.model.JobStepRestartMarker.Builder.() -> kotlin.Unit) {
            this.jobStepRestartMarker = aws.sdk.kotlin.services.m2.model.JobStepRestartMarker.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (executionId == null) executionId = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = BatchJobExecutionStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
