// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetApplicationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    public val applicationArn: kotlin.String = requireNotNull(builder.applicationArn) { "A non-null value must be provided for applicationArn" }
    /**
     * The identifier of the application.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The timestamp when this application was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The version of the application that is deployed.
     */
    public val deployedVersion: aws.sdk.kotlin.services.m2.model.DeployedVersionSummary? = builder.deployedVersion
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of the target platform for the application.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The identifier of the runtime environment where you want to deploy the application.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The identifier of a customer managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The timestamp when you last started the application. Null until the application runs for the first time.
     */
    public val lastStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStartTime
    /**
     * The latest version of the application.
     */
    public val latestVersion: aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary? = builder.latestVersion
    /**
     * The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services account. Amazon Web Services Mainframe Modernization creates this listener for you the first time you deploy an application.
     */
    public val listenerArns: List<String>? = builder.listenerArns
    /**
     * The port associated with the network load balancer listener created in your Amazon Web Services account.
     */
    public val listenerPorts: List<Int>? = builder.listenerPorts
    /**
     * The public DNS name of the load balancer created in your Amazon Web Services account.
     */
    public val loadBalancerDnsName: kotlin.String? = builder.loadBalancerDnsName
    /**
     * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These are CloudWatch logs. Amazon Web Services Mainframe Modernization pushes the application log to CloudWatch under the customer's account.
     */
    public val logGroups: List<LogGroupSummary>? = builder.logGroups
    /**
     * The unique identifier of the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) of the role associated with the application.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the application.
     */
    public val status: aws.sdk.kotlin.services.m2.model.ApplicationLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The reason for the reported status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A list of tags associated with the application.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.
     */
    public val targetGroupArns: List<String>? = builder.targetGroupArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.GetApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetApplicationResponse(")
        append("applicationArn=$applicationArn,")
        append("applicationId=$applicationId,")
        append("creationTime=$creationTime,")
        append("deployedVersion=$deployedVersion,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("environmentId=$environmentId,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastStartTime=$lastStartTime,")
        append("latestVersion=$latestVersion,")
        append("listenerArns=$listenerArns,")
        append("listenerPorts=$listenerPorts,")
        append("loadBalancerDnsName=$loadBalancerDnsName,")
        append("logGroups=$logGroups,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("targetGroupArns=$targetGroupArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn.hashCode()
        result = 31 * result + (applicationId.hashCode())
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (deployedVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastStartTime?.hashCode() ?: 0)
        result = 31 * result + (latestVersion?.hashCode() ?: 0)
        result = 31 * result + (listenerArns?.hashCode() ?: 0)
        result = 31 * result + (listenerPorts?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerDnsName?.hashCode() ?: 0)
        result = 31 * result + (logGroups?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetApplicationResponse

        if (applicationArn != other.applicationArn) return false
        if (applicationId != other.applicationId) return false
        if (creationTime != other.creationTime) return false
        if (deployedVersion != other.deployedVersion) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (environmentId != other.environmentId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastStartTime != other.lastStartTime) return false
        if (latestVersion != other.latestVersion) return false
        if (listenerArns != other.listenerArns) return false
        if (listenerPorts != other.listenerPorts) return false
        if (loadBalancerDnsName != other.loadBalancerDnsName) return false
        if (logGroups != other.logGroups) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (targetGroupArns != other.targetGroupArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.GetApplicationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The timestamp when this application was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of the application that is deployed.
         */
        public var deployedVersion: aws.sdk.kotlin.services.m2.model.DeployedVersionSummary? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * The type of the target platform for the application.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The identifier of the runtime environment where you want to deploy the application.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The identifier of a customer managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The timestamp when you last started the application. Null until the application runs for the first time.
         */
        public var lastStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The latest version of the application.
         */
        public var latestVersion: aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary? = null
        /**
         * The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services account. Amazon Web Services Mainframe Modernization creates this listener for you the first time you deploy an application.
         */
        public var listenerArns: List<String>? = null
        /**
         * The port associated with the network load balancer listener created in your Amazon Web Services account.
         */
        public var listenerPorts: List<Int>? = null
        /**
         * The public DNS name of the load balancer created in your Amazon Web Services account.
         */
        public var loadBalancerDnsName: kotlin.String? = null
        /**
         * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These are CloudWatch logs. Amazon Web Services Mainframe Modernization pushes the application log to CloudWatch under the customer's account.
         */
        public var logGroups: List<LogGroupSummary>? = null
        /**
         * The unique identifier of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role associated with the application.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the application.
         */
        public var status: aws.sdk.kotlin.services.m2.model.ApplicationLifecycle? = null
        /**
         * The reason for the reported status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A list of tags associated with the application.
         */
        public var tags: Map<String, String>? = null
        /**
         * Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.
         */
        public var targetGroupArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.GetApplicationResponse) : this() {
            this.applicationArn = x.applicationArn
            this.applicationId = x.applicationId
            this.creationTime = x.creationTime
            this.deployedVersion = x.deployedVersion
            this.description = x.description
            this.engineType = x.engineType
            this.environmentId = x.environmentId
            this.kmsKeyId = x.kmsKeyId
            this.lastStartTime = x.lastStartTime
            this.latestVersion = x.latestVersion
            this.listenerArns = x.listenerArns
            this.listenerPorts = x.listenerPorts
            this.loadBalancerDnsName = x.loadBalancerDnsName
            this.logGroups = x.logGroups
            this.name = x.name
            this.roleArn = x.roleArn
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.targetGroupArns = x.targetGroupArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.GetApplicationResponse = GetApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.DeployedVersionSummary] inside the given [block]
         */
        public fun deployedVersion(block: aws.sdk.kotlin.services.m2.model.DeployedVersionSummary.Builder.() -> kotlin.Unit) {
            this.deployedVersion = aws.sdk.kotlin.services.m2.model.DeployedVersionSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary] inside the given [block]
         */
        public fun latestVersion(block: aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary.Builder.() -> kotlin.Unit) {
            this.latestVersion = aws.sdk.kotlin.services.m2.model.ApplicationVersionSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationArn == null) applicationArn = ""
            if (applicationId == null) applicationId = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (status == null) status = ApplicationLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
