// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a subset of the possible runtime environment attributes. Used in the environment list.
 */
public class EnvironmentSummary private constructor(builder: Builder) {
    /**
     * The timestamp when the runtime environment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The target platform for the runtime environment.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The version of the runtime engine.
     */
    public val engineVersion: kotlin.String = requireNotNull(builder.engineVersion) { "A non-null value must be provided for engineVersion" }
    /**
     * The Amazon Resource Name (ARN) of a particular runtime environment.
     */
    public val environmentArn: kotlin.String = requireNotNull(builder.environmentArn) { "A non-null value must be provided for environmentArn" }
    /**
     * The unique identifier of a particular runtime environment.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * The instance type of the runtime environment.
     */
    public val instanceType: kotlin.String = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }
    /**
     * The name of the runtime environment.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the runtime environment
     */
    public val status: aws.sdk.kotlin.services.m2.model.EnvironmentLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.EnvironmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentSummary(")
        append("creationTime=$creationTime,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("environmentArn=$environmentArn,")
        append("environmentId=$environmentId,")
        append("instanceType=$instanceType,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (engineVersion.hashCode())
        result = 31 * result + (environmentArn.hashCode())
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (instanceType.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentSummary

        if (creationTime != other.creationTime) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (environmentArn != other.environmentArn) return false
        if (environmentId != other.environmentId) return false
        if (instanceType != other.instanceType) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.EnvironmentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when the runtime environment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The target platform for the runtime environment.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The version of the runtime engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a particular runtime environment.
         */
        public var environmentArn: kotlin.String? = null
        /**
         * The unique identifier of a particular runtime environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The instance type of the runtime environment.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The name of the runtime environment.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the runtime environment
         */
        public var status: aws.sdk.kotlin.services.m2.model.EnvironmentLifecycle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.EnvironmentSummary) : this() {
            this.creationTime = x.creationTime
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.environmentArn = x.environmentArn
            this.environmentId = x.environmentId
            this.instanceType = x.instanceType
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.EnvironmentSummary = EnvironmentSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (engineVersion == null) engineVersion = ""
            if (environmentArn == null) environmentArn = ""
            if (environmentId == null) environmentId = ""
            if (instanceType == null) instanceType = ""
            if (name == null) name = ""
            if (status == null) status = EnvironmentLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
