// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an environment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the runtime environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The engine type for the runtime environment.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The version of the engine type for the runtime environment.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The details of a high availability configuration for this runtime environment.
     */
    public val highAvailabilityConfig: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig? = builder.highAvailabilityConfig
    /**
     * The type of instance for the runtime environment.
     */
    public val instanceType: kotlin.String = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }
    /**
     * The identifier of a customer managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the runtime environment. Must be unique within the account.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. The following two examples are valid maintenance windows: `sun:23:45-mon:00:15` or `sat:01:00-sat:03:00`.
     *
     * If you do not provide a value, a random system-generated value will be assigned.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies whether the runtime environment is publicly accessible.
     */
    public val publiclyAccessible: kotlin.Boolean = builder.publiclyAccessible
    /**
     * The list of security groups for the VPC associated with this runtime environment.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Optional. The storage configurations for this runtime environment.
     */
    public val storageConfigurations: List<StorageConfiguration>? = builder.storageConfigurations
    /**
     * The list of subnets associated with the VPC for this runtime environment.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags for the runtime environment.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("highAvailabilityConfig=$highAvailabilityConfig,")
        append("instanceType=$instanceType,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroupIds=$securityGroupIds,")
        append("storageConfigurations=$storageConfigurations,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (highAvailabilityConfig?.hashCode() ?: 0)
        result = 31 * result + (instanceType.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (storageConfigurations?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (highAvailabilityConfig != other.highAvailabilityConfig) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (storageConfigurations != other.storageConfigurations) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an environment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the runtime environment.
         */
        public var description: kotlin.String? = null
        /**
         * The engine type for the runtime environment.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The version of the engine type for the runtime environment.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The details of a high availability configuration for this runtime environment.
         */
        public var highAvailabilityConfig: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig? = null
        /**
         * The type of instance for the runtime environment.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The identifier of a customer managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the runtime environment. Must be unique within the account.
         */
        public var name: kotlin.String? = null
        /**
         * Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. The following two examples are valid maintenance windows: `sun:23:45-mon:00:15` or `sat:01:00-sat:03:00`.
         *
         * If you do not provide a value, a random system-generated value will be assigned.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies whether the runtime environment is publicly accessible.
         */
        public var publiclyAccessible: kotlin.Boolean = false
        /**
         * The list of security groups for the VPC associated with this runtime environment.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * Optional. The storage configurations for this runtime environment.
         */
        public var storageConfigurations: List<StorageConfiguration>? = null
        /**
         * The list of subnets associated with the VPC for this runtime environment.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags for the runtime environment.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.highAvailabilityConfig = x.highAvailabilityConfig
            this.instanceType = x.instanceType
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroupIds = x.securityGroupIds
            this.storageConfigurations = x.storageConfigurations
            this.subnetIds = x.subnetIds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.CreateEnvironmentRequest = CreateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig] inside the given [block]
         */
        public fun highAvailabilityConfig(block: aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig.Builder.() -> kotlin.Unit) {
            this.highAvailabilityConfig = aws.sdk.kotlin.services.m2.model.HighAvailabilityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (instanceType == null) instanceType = ""
            if (name == null) name = ""
            return this
        }
    }
}
