// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.m2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A subset of the possible application attributes. Used in the application list.
 */
public class ApplicationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    public val applicationArn: kotlin.String = requireNotNull(builder.applicationArn) { "A non-null value must be provided for applicationArn" }
    /**
     * The unique identifier of the application.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The version of the application.
     */
    public val applicationVersion: kotlin.Int = requireNotNull(builder.applicationVersion) { "A non-null value must be provided for applicationVersion" }
    /**
     * The timestamp when the application was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Indicates either an ongoing deployment or if the application has ever deployed successfully.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.m2.model.ApplicationDeploymentLifecycle? = builder.deploymentStatus
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of the target platform for this application.
     */
    public val engineType: aws.sdk.kotlin.services.m2.model.EngineType = requireNotNull(builder.engineType) { "A non-null value must be provided for engineType" }
    /**
     * The unique identifier of the runtime environment that hosts this application.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The timestamp when you last started the application. Null until the application runs for the first time.
     */
    public val lastStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStartTime
    /**
     * The name of the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) of the role associated with the application.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the application.
     */
    public val status: aws.sdk.kotlin.services.m2.model.ApplicationLifecycle = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Indicates the status of the latest version of the application.
     */
    public val versionStatus: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle? = builder.versionStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.m2.model.ApplicationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSummary(")
        append("applicationArn=$applicationArn,")
        append("applicationId=$applicationId,")
        append("applicationVersion=$applicationVersion,")
        append("creationTime=$creationTime,")
        append("deploymentStatus=$deploymentStatus,")
        append("description=$description,")
        append("engineType=$engineType,")
        append("environmentId=$environmentId,")
        append("lastStartTime=$lastStartTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("versionStatus=$versionStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn.hashCode()
        result = 31 * result + (applicationId.hashCode())
        result = 31 * result + (applicationVersion)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineType.hashCode())
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (lastStartTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (versionStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSummary

        if (applicationArn != other.applicationArn) return false
        if (applicationId != other.applicationId) return false
        if (applicationVersion != other.applicationVersion) return false
        if (creationTime != other.creationTime) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (description != other.description) return false
        if (engineType != other.engineType) return false
        if (environmentId != other.environmentId) return false
        if (lastStartTime != other.lastStartTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (versionStatus != other.versionStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.m2.model.ApplicationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The unique identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var applicationVersion: kotlin.Int? = null
        /**
         * The timestamp when the application was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates either an ongoing deployment or if the application has ever deployed successfully.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.m2.model.ApplicationDeploymentLifecycle? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * The type of the target platform for this application.
         */
        public var engineType: aws.sdk.kotlin.services.m2.model.EngineType? = null
        /**
         * The unique identifier of the runtime environment that hosts this application.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The timestamp when you last started the application. Null until the application runs for the first time.
         */
        public var lastStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role associated with the application.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the application.
         */
        public var status: aws.sdk.kotlin.services.m2.model.ApplicationLifecycle? = null
        /**
         * Indicates the status of the latest version of the application.
         */
        public var versionStatus: aws.sdk.kotlin.services.m2.model.ApplicationVersionLifecycle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.m2.model.ApplicationSummary) : this() {
            this.applicationArn = x.applicationArn
            this.applicationId = x.applicationId
            this.applicationVersion = x.applicationVersion
            this.creationTime = x.creationTime
            this.deploymentStatus = x.deploymentStatus
            this.description = x.description
            this.engineType = x.engineType
            this.environmentId = x.environmentId
            this.lastStartTime = x.lastStartTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.status = x.status
            this.versionStatus = x.versionStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.m2.model.ApplicationSummary = ApplicationSummary(this)

        internal fun correctErrors(): Builder {
            if (applicationArn == null) applicationArn = ""
            if (applicationId == null) applicationId = ""
            if (applicationVersion == null) applicationVersion = 0
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (engineType == null) engineType = EngineType.SdkUnknown("no value provided")
            if (name == null) name = ""
            if (status == null) status = ApplicationLifecycle.SdkUnknown("no value provided")
            return this
        }
    }
}
