// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.serde

import aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartModelOperationSerializer: HttpSerialize<StartModelRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartModelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            requireNotNull(input.modelVersion) { "modelVersion is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2020-11-20"))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode("${input.projectName}"))
                add(PercentEncoding.Path.encode("models"))
                add(PercentEncoding.SmithyLabel.encode("${input.modelVersion}"))
                add(PercentEncoding.Path.encode("start"))
            }
        }

        builder.headers {
            append("X-Amzn-Client-Token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeStartModelOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartModelOperationBody(context: ExecutionContext, input: StartModelRequest): ByteArray {
    val serializer = JsonSerializer()
    val MAXINFERENCEUNITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxInferenceUnits"))
    val MININFERENCEUNITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinInferenceUnits"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAXINFERENCEUNITS_DESCRIPTOR)
        field(MININFERENCEUNITS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.maxInferenceUnits?.let { field(MAXINFERENCEUNITS_DESCRIPTOR, it) }
        input.minInferenceUnits?.let { field(MININFERENCEUNITS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
