// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.serde

import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListDatasetEntriesOperationSerializer: HttpSerialize<ListDatasetEntriesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListDatasetEntriesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            requireNotNull(input.datasetType) { "datasetType is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2020-11-20"))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode("${input.projectName}"))
                add(PercentEncoding.Path.encode("datasets"))
                add(PercentEncoding.SmithyLabel.encode("${input.datasetType}"))
                add(PercentEncoding.Path.encode("entries"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.afterCreationDate != null) add("createdAfter", input.afterCreationDate.format(TimestampFormat.ISO_8601))
                if (input.anomalyClass != null) add("anomalyClass", input.anomalyClass)
                if (input.beforeCreationDate != null) add("createdBefore", input.beforeCreationDate.format(TimestampFormat.ISO_8601))
                if (input.labeled != null) add("labeled", "${input.labeled}")
                if (input.maxResults != null) add("maxResults", "${input.maxResults}")
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.sourceRefContains != null) add("sourceRefContains", input.sourceRefContains)
            }
        }

        return builder
    }
}
