// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.serde

import aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest
import aws.sdk.kotlin.services.lookoutvision.model.DatasetSource
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDatasetOperationSerializer: HttpSerialize<CreateDatasetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDatasetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2020-11-20"))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode("${input.projectName}"))
                add(PercentEncoding.Path.encode("datasets"))
            }
        }

        builder.headers {
            append("X-Amzn-Client-Token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeCreateDatasetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDatasetOperationBody(context: ExecutionContext, input: CreateDatasetRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATASETSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DatasetSource"))
    val DATASETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DatasetType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASETSOURCE_DESCRIPTOR)
        field(DATASETTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.datasetSource?.let { field(DATASETSOURCE_DESCRIPTOR, it, ::serializeDatasetSourceDocument) }
        input.datasetType?.let { field(DATASETTYPE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
