// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.paginators

import aws.sdk.kotlin.services.lookoutvision.LookoutVisionClient
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ModelMetadata
import aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingJobMetadata
import aws.sdk.kotlin.services.lookoutvision.model.ProjectMetadata
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetEntriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
public fun LookoutVisionClient.listDatasetEntriesPaginated(initialRequest: ListDatasetEntriesRequest): Flow<ListDatasetEntriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetEntriesPaginated.listDatasetEntries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
public fun LookoutVisionClient.listDatasetEntriesPaginated(block: ListDatasetEntriesRequest.Builder.() -> Unit): Flow<ListDatasetEntriesResponse> =
    listDatasetEntriesPaginated(ListDatasetEntriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetEntriesPaginated]
 * to access the nested member [DatasetEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetEntry]
 */
@JvmName("listDatasetEntriesResponseDatasetEntry")
public fun Flow<ListDatasetEntriesResponse>.datasetEntries(): Flow<String> =
    transform() { response ->
        response.datasetEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelPackagingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelPackagingJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelPackagingJobsResponse]
 */
public fun LookoutVisionClient.listModelPackagingJobsPaginated(initialRequest: ListModelPackagingJobsRequest): Flow<ListModelPackagingJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelPackagingJobsPaginated.listModelPackagingJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelPackagingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelPackagingJobsResponse]
 */
public fun LookoutVisionClient.listModelPackagingJobsPaginated(block: ListModelPackagingJobsRequest.Builder.() -> Unit): Flow<ListModelPackagingJobsResponse> =
    listModelPackagingJobsPaginated(ListModelPackagingJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelPackagingJobsPaginated]
 * to access the nested member [ModelPackagingJobMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelPackagingJobMetadata]
 */
@JvmName("listModelPackagingJobsResponseModelPackagingJobMetadata")
public fun Flow<ListModelPackagingJobsResponse>.modelPackagingJobs(): Flow<ModelPackagingJobMetadata> =
    transform() { response ->
        response.modelPackagingJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelsResponse]
 */
public fun LookoutVisionClient.listModelsPaginated(initialRequest: ListModelsRequest): Flow<ListModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelsPaginated.listModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelsResponse]
 */
public fun LookoutVisionClient.listModelsPaginated(block: ListModelsRequest.Builder.() -> Unit): Flow<ListModelsResponse> =
    listModelsPaginated(ListModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelsPaginated]
 * to access the nested member [ModelMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelMetadata]
 */
@JvmName("listModelsResponseModelMetadata")
public fun Flow<ListModelsResponse>.models(): Flow<ModelMetadata> =
    transform() { response ->
        response.models?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun LookoutVisionClient.listProjectsPaginated(initialRequest: ListProjectsRequest = ListProjectsRequest { }): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun LookoutVisionClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [ProjectMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectMetadata]
 */
@JvmName("listProjectsResponseProjectMetadata")
public fun Flow<ListProjectsResponse>.projects(): Flow<ProjectMetadata> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }
