// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



public class UpdateDatasetEntriesRequest private constructor(builder: Builder) {
    /**
     * The entries to add to the dataset.
     */
    public val changes: kotlin.ByteArray? = builder.changes
    /**
     * ClientToken is an idempotency token that ensures a call to `UpdateDatasetEntries` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `UpdateDatasetEntries`. In this case, safely retry your call to `UpdateDatasetEntries` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `UpdateDatasetEntries`. An idempotency token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The type of the dataset that you want to update. Specify `train` to update the training dataset. Specify `test` to update the test dataset. If you have a single dataset project, specify `train`.
     */
    public val datasetType: kotlin.String? = builder.datasetType
    /**
     * The name of the project that contains the dataset that you want to update.
     */
    public val projectName: kotlin.String? = builder.projectName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDatasetEntriesRequest(")
        append("changes=$changes,")
        append("clientToken=$clientToken,")
        append("datasetType=$datasetType,")
        append("projectName=$projectName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changes?.contentHashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDatasetEntriesRequest

        if (changes != null) {
            if (other.changes == null) return false
            if (!changes.contentEquals(other.changes)) return false
        } else if (other.changes != null) return false
        if (clientToken != other.clientToken) return false
        if (datasetType != other.datasetType) return false
        if (projectName != other.projectName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The entries to add to the dataset.
         */
        public var changes: kotlin.ByteArray? = null
        /**
         * ClientToken is an idempotency token that ensures a call to `UpdateDatasetEntries` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `UpdateDatasetEntries`. In this case, safely retry your call to `UpdateDatasetEntries` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `UpdateDatasetEntries`. An idempotency token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The type of the dataset that you want to update. Specify `train` to update the training dataset. Specify `test` to update the test dataset. If you have a single dataset project, specify `train`.
         */
        public var datasetType: kotlin.String? = null
        /**
         * The name of the project that contains the dataset that you want to update.
         */
        public var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesRequest) : this() {
            this.changes = x.changes
            this.clientToken = x.clientToken
            this.datasetType = x.datasetType
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesRequest = UpdateDatasetEntriesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
