// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



/**
 * The platform on which a model runs on an AWS IoT Greengrass core device.
 */
public class TargetPlatform private constructor(builder: Builder) {
    /**
     * The target accelerator for the model. Currently, Amazon Lookout for Vision only supports NVIDIA (Nvidia graphics processing unit) and CPU accelerators. If you specify NVIDIA as an accelerator, you must also specify the `gpu-code`, `trt-ver`, and `cuda-ver` compiler options. If you don't specify an accelerator, Lookout for Vision uses the CPU for compilation and we highly recommend that you use the GreengrassConfiguration$CompilerOptions field. For example, you can use the following compiler options for CPU:
     * + `mcpu`: CPU micro-architecture. For example, `{'mcpu': 'skylake-avx512'}`
     * + `mattr`: CPU flags. For example, `{'mattr': ['+neon', '+vfpv4']}`
     */
    public val accelerator: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformAccelerator? = builder.accelerator
    /**
     * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
     */
    public val arch: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformArch? = builder.arch
    /**
     * The target operating system for the model. Linux is the only operating system that is currently supported.
     */
    public val os: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformOs? = builder.os

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetPlatform(")
        append("accelerator=$accelerator,")
        append("arch=$arch,")
        append("os=$os")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerator?.hashCode() ?: 0
        result = 31 * result + (arch?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetPlatform

        if (accelerator != other.accelerator) return false
        if (arch != other.arch) return false
        if (os != other.os) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The target accelerator for the model. Currently, Amazon Lookout for Vision only supports NVIDIA (Nvidia graphics processing unit) and CPU accelerators. If you specify NVIDIA as an accelerator, you must also specify the `gpu-code`, `trt-ver`, and `cuda-ver` compiler options. If you don't specify an accelerator, Lookout for Vision uses the CPU for compilation and we highly recommend that you use the GreengrassConfiguration$CompilerOptions field. For example, you can use the following compiler options for CPU:
         * + `mcpu`: CPU micro-architecture. For example, `{'mcpu': 'skylake-avx512'}`
         * + `mattr`: CPU flags. For example, `{'mattr': ['+neon', '+vfpv4']}`
         */
        public var accelerator: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformAccelerator? = null
        /**
         * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
         */
        public var arch: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformArch? = null
        /**
         * The target operating system for the model. Linux is the only operating system that is currently supported.
         */
        public var os: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatformOs? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform) : this() {
            this.accelerator = x.accelerator
            this.arch = x.arch
            this.os = x.os
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform = TargetPlatform(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
