// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



public class StartModelRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `StartModel` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `StartModel`. In this case, safely retry your call to `StartModel` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `StartModel`. An idempotency token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The maximum number of inference units to use for auto-scaling the model. If you don't specify a value, Amazon Lookout for Vision doesn't auto-scale the model.
     */
    public val maxInferenceUnits: kotlin.Int? = builder.maxInferenceUnits
    /**
     * The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use.
     */
    public val minInferenceUnits: kotlin.Int? = builder.minInferenceUnits
    /**
     * The version of the model that you want to start.
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The name of the project that contains the model that you want to start.
     */
    public val projectName: kotlin.String? = builder.projectName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartModelRequest(")
        append("clientToken=$clientToken,")
        append("maxInferenceUnits=$maxInferenceUnits,")
        append("minInferenceUnits=$minInferenceUnits,")
        append("modelVersion=$modelVersion,")
        append("projectName=$projectName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (maxInferenceUnits ?: 0)
        result = 31 * result + (minInferenceUnits ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartModelRequest

        if (clientToken != other.clientToken) return false
        if (maxInferenceUnits != other.maxInferenceUnits) return false
        if (minInferenceUnits != other.minInferenceUnits) return false
        if (modelVersion != other.modelVersion) return false
        if (projectName != other.projectName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `StartModel` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `StartModel`. In this case, safely retry your call to `StartModel` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `StartModel`. An idempotency token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The maximum number of inference units to use for auto-scaling the model. If you don't specify a value, Amazon Lookout for Vision doesn't auto-scale the model.
         */
        public var maxInferenceUnits: kotlin.Int? = null
        /**
         * The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use.
         */
        public var minInferenceUnits: kotlin.Int? = null
        /**
         * The version of the model that you want to start.
         */
        public var modelVersion: kotlin.String? = null
        /**
         * The name of the project that contains the model that you want to start.
         */
        public var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest) : this() {
            this.clientToken = x.clientToken
            this.maxInferenceUnits = x.maxInferenceUnits
            this.minInferenceUnits = x.minInferenceUnits
            this.modelVersion = x.modelVersion
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest = StartModelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
