// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a model packaging job. For more information, see DescribeModelPackagingJob.
 */
public class ModelPackagingDescription private constructor(builder: Builder) {
    /**
     * The Unix timestamp for the time and date that the model packaging job was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The name of the model packaging job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The Unix timestamp for the time and date that the model packaging job was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The configuration information used in the model packaging job.
     */
    public val modelPackagingConfiguration: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration? = builder.modelPackagingConfiguration
    /**
     * The description for the model packaging job.
     */
    public val modelPackagingJobDescription: kotlin.String? = builder.modelPackagingJobDescription
    /**
     * The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT Greengrass.
     */
    public val modelPackagingMethod: kotlin.String? = builder.modelPackagingMethod
    /**
     * Information about the output of the model packaging job. For more information, see DescribeModelPackagingJob.
     */
    public val modelPackagingOutputDetails: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingOutputDetails? = builder.modelPackagingOutputDetails
    /**
     * The version of the model used in the model packaging job.
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The name of the project that's associated with a model that's in the model package.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * The status of the model packaging job.
     */
    public val status: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingJobStatus? = builder.status
    /**
     * The status message for the model packaging job.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackagingDescription(")
        append("creationTimestamp=$creationTimestamp,")
        append("jobName=$jobName,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("modelPackagingConfiguration=$modelPackagingConfiguration,")
        append("modelPackagingJobDescription=$modelPackagingJobDescription,")
        append("modelPackagingMethod=$modelPackagingMethod,")
        append("modelPackagingOutputDetails=$modelPackagingOutputDetails,")
        append("modelVersion=$modelVersion,")
        append("projectName=$projectName,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (modelPackagingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (modelPackagingJobDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackagingMethod?.hashCode() ?: 0)
        result = 31 * result + (modelPackagingOutputDetails?.hashCode() ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackagingDescription

        if (creationTimestamp != other.creationTimestamp) return false
        if (jobName != other.jobName) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (modelPackagingConfiguration != other.modelPackagingConfiguration) return false
        if (modelPackagingJobDescription != other.modelPackagingJobDescription) return false
        if (modelPackagingMethod != other.modelPackagingMethod) return false
        if (modelPackagingOutputDetails != other.modelPackagingOutputDetails) return false
        if (modelVersion != other.modelVersion) return false
        if (projectName != other.projectName) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unix timestamp for the time and date that the model packaging job was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the model packaging job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The Unix timestamp for the time and date that the model packaging job was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration information used in the model packaging job.
         */
        public var modelPackagingConfiguration: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration? = null
        /**
         * The description for the model packaging job.
         */
        public var modelPackagingJobDescription: kotlin.String? = null
        /**
         * The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT Greengrass.
         */
        public var modelPackagingMethod: kotlin.String? = null
        /**
         * Information about the output of the model packaging job. For more information, see DescribeModelPackagingJob.
         */
        public var modelPackagingOutputDetails: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingOutputDetails? = null
        /**
         * The version of the model used in the model packaging job.
         */
        public var modelVersion: kotlin.String? = null
        /**
         * The name of the project that's associated with a model that's in the model package.
         */
        public var projectName: kotlin.String? = null
        /**
         * The status of the model packaging job.
         */
        public var status: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingJobStatus? = null
        /**
         * The status message for the model packaging job.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingDescription) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.jobName = x.jobName
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.modelPackagingConfiguration = x.modelPackagingConfiguration
            this.modelPackagingJobDescription = x.modelPackagingJobDescription
            this.modelPackagingMethod = x.modelPackagingMethod
            this.modelPackagingOutputDetails = x.modelPackagingOutputDetails
            this.modelVersion = x.modelVersion
            this.projectName = x.projectName
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingDescription = ModelPackagingDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration] inside the given [block]
         */
        public fun modelPackagingConfiguration(block: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration.Builder.() -> kotlin.Unit) {
            this.modelPackagingConfiguration = aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingOutputDetails] inside the given [block]
         */
        public fun modelPackagingOutputDetails(block: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingOutputDetails.Builder.() -> kotlin.Unit) {
            this.modelPackagingOutputDetails = aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingOutputDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
