// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Lookout for Vision model.
 */
public class ModelMetadata private constructor(builder: Builder) {
    /**
     * The unix timestamp for the date and time that the model was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The description for the model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the model.
     */
    public val modelArn: kotlin.String? = builder.modelArn
    /**
     * The version of the model.
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * Performance metrics for the model. Not available until training has successfully completed.
     */
    public val performance: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance? = builder.performance
    /**
     * The status of the model.
     */
    public val status: aws.sdk.kotlin.services.lookoutvision.model.ModelStatus? = builder.status
    /**
     * The status message for the model.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.ModelMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelMetadata(")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("modelArn=$modelArn,")
        append("modelVersion=$modelVersion,")
        append("performance=$performance,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (performance?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelMetadata

        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (modelArn != other.modelArn) return false
        if (modelVersion != other.modelVersion) return false
        if (performance != other.performance) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.ModelMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unix timestamp for the date and time that the model was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the model.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * The version of the model.
         */
        public var modelVersion: kotlin.String? = null
        /**
         * Performance metrics for the model. Not available until training has successfully completed.
         */
        public var performance: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance? = null
        /**
         * The status of the model.
         */
        public var status: aws.sdk.kotlin.services.lookoutvision.model.ModelStatus? = null
        /**
         * The status message for the model.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.ModelMetadata) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.modelArn = x.modelArn
            this.modelVersion = x.modelVersion
            this.performance = x.performance
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.ModelMetadata = ModelMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance] inside the given [block]
         */
        public fun performance(block: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance.Builder.() -> kotlin.Unit) {
            this.performance = aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
