// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Lookout for Vision model.
 */
public class ModelDescription private constructor(builder: Builder) {
    /**
     * The unix timestamp for the date and time that the model was created.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The description for the model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unix timestamp for the date and time that the evaluation ended.
     */
    public val evaluationEndTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.evaluationEndTimestamp
    /**
     * The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained model and generate the performance scores.
     */
    public val evaluationManifest: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object? = builder.evaluationManifest
    /**
     * The S3 location where Amazon Lookout for Vision saves the performance metrics.
     */
    public val evaluationResult: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object? = builder.evaluationResult
    /**
     * The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during training.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more information, see StartModel.
     */
    public val maxInferenceUnits: kotlin.Int? = builder.maxInferenceUnits
    /**
     * The minimum number of inference units used by the model. For more information, see StartModel
     */
    public val minInferenceUnits: kotlin.Int? = builder.minInferenceUnits
    /**
     * The Amazon Resource Name (ARN) of the model.
     */
    public val modelArn: kotlin.String? = builder.modelArn
    /**
     * The version of the model
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The S3 location where Amazon Lookout for Vision saves model training files.
     */
    public val outputConfig: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig? = builder.outputConfig
    /**
     * Performance metrics for the model. Created during training.
     */
    public val performance: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance? = builder.performance
    /**
     * The status of the model.
     */
    public val status: aws.sdk.kotlin.services.lookoutvision.model.ModelStatus? = builder.status
    /**
     * The status message for the model.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.ModelDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelDescription(")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("evaluationEndTimestamp=$evaluationEndTimestamp,")
        append("evaluationManifest=$evaluationManifest,")
        append("evaluationResult=$evaluationResult,")
        append("kmsKeyId=$kmsKeyId,")
        append("maxInferenceUnits=$maxInferenceUnits,")
        append("minInferenceUnits=$minInferenceUnits,")
        append("modelArn=$modelArn,")
        append("modelVersion=$modelVersion,")
        append("outputConfig=$outputConfig,")
        append("performance=$performance,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (evaluationEndTimestamp?.hashCode() ?: 0)
        result = 31 * result + (evaluationManifest?.hashCode() ?: 0)
        result = 31 * result + (evaluationResult?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maxInferenceUnits ?: 0)
        result = 31 * result + (minInferenceUnits ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (performance?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelDescription

        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (evaluationEndTimestamp != other.evaluationEndTimestamp) return false
        if (evaluationManifest != other.evaluationManifest) return false
        if (evaluationResult != other.evaluationResult) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maxInferenceUnits != other.maxInferenceUnits) return false
        if (minInferenceUnits != other.minInferenceUnits) return false
        if (modelArn != other.modelArn) return false
        if (modelVersion != other.modelVersion) return false
        if (outputConfig != other.outputConfig) return false
        if (performance != other.performance) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.ModelDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unix timestamp for the date and time that the model was created.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the model.
         */
        public var description: kotlin.String? = null
        /**
         * The unix timestamp for the date and time that the evaluation ended.
         */
        public var evaluationEndTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The S3 location where Amazon Lookout for Vision saves the manifest file that was used to test the trained model and generate the performance scores.
         */
        public var evaluationManifest: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object? = null
        /**
         * The S3 location where Amazon Lookout for Vision saves the performance metrics.
         */
        public var evaluationResult: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object? = null
        /**
         * The identifer for the AWS Key Management Service (AWS KMS) key that was used to encrypt the model during training.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The maximum number of inference units Amazon Lookout for Vision uses to auto-scale the model. For more information, see StartModel.
         */
        public var maxInferenceUnits: kotlin.Int? = null
        /**
         * The minimum number of inference units used by the model. For more information, see StartModel
         */
        public var minInferenceUnits: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * The version of the model
         */
        public var modelVersion: kotlin.String? = null
        /**
         * The S3 location where Amazon Lookout for Vision saves model training files.
         */
        public var outputConfig: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig? = null
        /**
         * Performance metrics for the model. Created during training.
         */
        public var performance: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance? = null
        /**
         * The status of the model.
         */
        public var status: aws.sdk.kotlin.services.lookoutvision.model.ModelStatus? = null
        /**
         * The status message for the model.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.ModelDescription) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.evaluationEndTimestamp = x.evaluationEndTimestamp
            this.evaluationManifest = x.evaluationManifest
            this.evaluationResult = x.evaluationResult
            this.kmsKeyId = x.kmsKeyId
            this.maxInferenceUnits = x.maxInferenceUnits
            this.minInferenceUnits = x.minInferenceUnits
            this.modelArn = x.modelArn
            this.modelVersion = x.modelVersion
            this.outputConfig = x.outputConfig
            this.performance = x.performance
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.ModelDescription = ModelDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object] inside the given [block]
         */
        public fun evaluationManifest(block: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object.Builder.() -> kotlin.Unit) {
            this.evaluationManifest = aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object] inside the given [block]
         */
        public fun evaluationResult(block: aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object.Builder.() -> kotlin.Unit) {
            this.evaluationResult = aws.sdk.kotlin.services.lookoutvision.model.OutputS3Object.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.lookoutvision.model.OutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance] inside the given [block]
         */
        public fun performance(block: aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance.Builder.() -> kotlin.Unit) {
            this.performance = aws.sdk.kotlin.services.lookoutvision.model.ModelPerformance.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
