// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



/**
 * The prediction results from a call to DetectAnomalies. `DetectAnomalyResult` includes classification information for the prediction (`IsAnomalous` and `Confidence`). If the model you use is an image segementation model, `DetectAnomalyResult` also includes segmentation information (`Anomalies` and `AnomalyMask`). Classification information is calculated separately from segmentation information and you shouldn't assume a relationship between them.
 */
public class DetectAnomalyResult private constructor(builder: Builder) {
    /**
     * If the model is an image segmentation model, `Anomalies` contains a list of anomaly types found in the image. There is one entry for each type of anomaly found (even if multiple instances of an anomaly type exist on the image). The first element in the list is always an anomaly type representing the image background ('background') and shouldn't be considered an anomaly. Amazon Lookout for Vision automatically add the background anomaly type to the response, and you don't need to declare a background anomaly type in your dataset.
     *
     * If the list has one entry ('background'), no anomalies were found on the image.
     *
     * An image classification model doesn't return an `Anomalies` list.
     */
    public val anomalies: List<Anomaly>? = builder.anomalies
    /**
     * If the model is an image segmentation model, `AnomalyMask` contains pixel masks that covers all anomaly types found on the image. Each anomaly type has a different mask color. To map a color to an anomaly type, see the `color` field of the PixelAnomaly object.
     *
     * An image classification model doesn't return an `Anomalies` list.
     */
    public val anomalyMask: kotlin.ByteArray? = builder.anomalyMask
    /**
     * The confidence that Lookout for Vision has in the accuracy of the classification in `IsAnomalous`.
     */
    public val confidence: kotlin.Float? = builder.confidence
    /**
     * True if Amazon Lookout for Vision classifies the image as containing an anomaly, otherwise false.
     */
    public val isAnomalous: kotlin.Boolean? = builder.isAnomalous
    /**
     * The source of the image that was analyzed. `direct` means that the images was supplied from the local computer. No other values are supported.
     */
    public val source: aws.sdk.kotlin.services.lookoutvision.model.ImageSource? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.DetectAnomalyResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectAnomalyResult(")
        append("anomalies=$anomalies,")
        append("anomalyMask=$anomalyMask,")
        append("confidence=$confidence,")
        append("isAnomalous=$isAnomalous,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalies?.hashCode() ?: 0
        result = 31 * result + (anomalyMask?.contentHashCode() ?: 0)
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (isAnomalous?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectAnomalyResult

        if (anomalies != other.anomalies) return false
        if (anomalyMask != null) {
            if (other.anomalyMask == null) return false
            if (!anomalyMask.contentEquals(other.anomalyMask)) return false
        } else if (other.anomalyMask != null) return false
        if (confidence != other.confidence) return false
        if (isAnomalous != other.isAnomalous) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.DetectAnomalyResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the model is an image segmentation model, `Anomalies` contains a list of anomaly types found in the image. There is one entry for each type of anomaly found (even if multiple instances of an anomaly type exist on the image). The first element in the list is always an anomaly type representing the image background ('background') and shouldn't be considered an anomaly. Amazon Lookout for Vision automatically add the background anomaly type to the response, and you don't need to declare a background anomaly type in your dataset.
         *
         * If the list has one entry ('background'), no anomalies were found on the image.
         *
         * An image classification model doesn't return an `Anomalies` list.
         */
        public var anomalies: List<Anomaly>? = null
        /**
         * If the model is an image segmentation model, `AnomalyMask` contains pixel masks that covers all anomaly types found on the image. Each anomaly type has a different mask color. To map a color to an anomaly type, see the `color` field of the PixelAnomaly object.
         *
         * An image classification model doesn't return an `Anomalies` list.
         */
        public var anomalyMask: kotlin.ByteArray? = null
        /**
         * The confidence that Lookout for Vision has in the accuracy of the classification in `IsAnomalous`.
         */
        public var confidence: kotlin.Float? = null
        /**
         * True if Amazon Lookout for Vision classifies the image as containing an anomaly, otherwise false.
         */
        public var isAnomalous: kotlin.Boolean? = null
        /**
         * The source of the image that was analyzed. `direct` means that the images was supplied from the local computer. No other values are supported.
         */
        public var source: aws.sdk.kotlin.services.lookoutvision.model.ImageSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.DetectAnomalyResult) : this() {
            this.anomalies = x.anomalies
            this.anomalyMask = x.anomalyMask
            this.confidence = x.confidence
            this.isAnomalous = x.isAnomalous
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.DetectAnomalyResult = DetectAnomalyResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ImageSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.lookoutvision.model.ImageSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.lookoutvision.model.ImageSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
