// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



public class DeleteModelRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `DeleteModel` completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from `DeleteModel`. In this case, safely retry your call to `DeleteModel` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `DeleteModel`. An idempotency token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The version of the model that you want to delete.
     */
    public val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The name of the project that contains the model that you want to delete.
     */
    public val projectName: kotlin.String? = builder.projectName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.DeleteModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteModelRequest(")
        append("clientToken=$clientToken,")
        append("modelVersion=$modelVersion,")
        append("projectName=$projectName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteModelRequest

        if (clientToken != other.clientToken) return false
        if (modelVersion != other.modelVersion) return false
        if (projectName != other.projectName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.DeleteModelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `DeleteModel` completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from `DeleteModel`. In this case, safely retry your call to `DeleteModel` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `DeleteModel`. An idempotency token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The version of the model that you want to delete.
         */
        public var modelVersion: kotlin.String? = null
        /**
         * The name of the project that contains the model that you want to delete.
         */
        public var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.DeleteModelRequest) : this() {
            this.clientToken = x.clientToken
            this.modelVersion = x.modelVersion
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.DeleteModelRequest = DeleteModelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
