// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



public class CreateDatasetRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `CreateDataset` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `CreateDataset`. In this case, safely retry your call to `CreateDataset` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `CreateDataset`. An idempotency token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.
     *
     * If you don't specify `DatasetSource`, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling UpdateDatasetEntries.
     *
     * If you specify a value for `DataSource`, the manifest at the S3 location is validated and used to create the dataset. The call to `CreateDataset` is asynchronous and might take a while to complete. To find out the current status, Check the value of `Status` returned in a call to DescribeDataset.
     */
    public val datasetSource: aws.sdk.kotlin.services.lookoutvision.model.DatasetSource? = builder.datasetSource
    /**
     * The type of the dataset. Specify `train` for a training dataset. Specify `test` for a test dataset.
     */
    public val datasetType: kotlin.String? = builder.datasetType
    /**
     * The name of the project in which you want to create a dataset.
     */
    public val projectName: kotlin.String? = builder.projectName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetRequest(")
        append("clientToken=$clientToken,")
        append("datasetSource=$datasetSource,")
        append("datasetType=$datasetType,")
        append("projectName=$projectName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (datasetSource?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetRequest

        if (clientToken != other.clientToken) return false
        if (datasetSource != other.datasetSource) return false
        if (datasetType != other.datasetType) return false
        if (projectName != other.projectName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `CreateDataset` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `CreateDataset`. In this case, safely retry your call to `CreateDataset` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `CreateDataset`. An idempotency token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.
         *
         * If you don't specify `DatasetSource`, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling UpdateDatasetEntries.
         *
         * If you specify a value for `DataSource`, the manifest at the S3 location is validated and used to create the dataset. The call to `CreateDataset` is asynchronous and might take a while to complete. To find out the current status, Check the value of `Status` returned in a call to DescribeDataset.
         */
        public var datasetSource: aws.sdk.kotlin.services.lookoutvision.model.DatasetSource? = null
        /**
         * The type of the dataset. Specify `train` for a training dataset. Specify `test` for a test dataset.
         */
        public var datasetType: kotlin.String? = null
        /**
         * The name of the project in which you want to create a dataset.
         */
        public var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest) : this() {
            this.clientToken = x.clientToken
            this.datasetSource = x.datasetSource
            this.datasetType = x.datasetType
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest = CreateDatasetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.DatasetSource] inside the given [block]
         */
        public fun datasetSource(block: aws.sdk.kotlin.services.lookoutvision.model.DatasetSource.Builder.() -> kotlin.Unit) {
            this.datasetSource = aws.sdk.kotlin.services.lookoutvision.model.DatasetSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
