// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.lookoutvision.auth.DefaultLookoutVisionAuthSchemeProvider
import aws.sdk.kotlin.services.lookoutvision.auth.LookoutVisionAuthSchemeProvider
import aws.sdk.kotlin.services.lookoutvision.endpoints.DefaultLookoutVisionEndpointProvider
import aws.sdk.kotlin.services.lookoutvision.endpoints.LookoutVisionEndpointParameters
import aws.sdk.kotlin.services.lookoutvision.endpoints.LookoutVisionEndpointProvider
import aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetRequest
import aws.sdk.kotlin.services.lookoutvision.model.CreateDatasetResponse
import aws.sdk.kotlin.services.lookoutvision.model.CreateModelRequest
import aws.sdk.kotlin.services.lookoutvision.model.CreateModelResponse
import aws.sdk.kotlin.services.lookoutvision.model.CreateProjectRequest
import aws.sdk.kotlin.services.lookoutvision.model.CreateProjectResponse
import aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetRequest
import aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetResponse
import aws.sdk.kotlin.services.lookoutvision.model.DeleteModelRequest
import aws.sdk.kotlin.services.lookoutvision.model.DeleteModelResponse
import aws.sdk.kotlin.services.lookoutvision.model.DeleteProjectRequest
import aws.sdk.kotlin.services.lookoutvision.model.DeleteProjectResponse
import aws.sdk.kotlin.services.lookoutvision.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.lookoutvision.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.lookoutvision.model.DescribeModelPackagingJobRequest
import aws.sdk.kotlin.services.lookoutvision.model.DescribeModelPackagingJobResponse
import aws.sdk.kotlin.services.lookoutvision.model.DescribeModelRequest
import aws.sdk.kotlin.services.lookoutvision.model.DescribeModelResponse
import aws.sdk.kotlin.services.lookoutvision.model.DescribeProjectRequest
import aws.sdk.kotlin.services.lookoutvision.model.DescribeProjectResponse
import aws.sdk.kotlin.services.lookoutvision.model.DetectAnomaliesRequest
import aws.sdk.kotlin.services.lookoutvision.model.DetectAnomaliesResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobRequest
import aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobResponse
import aws.sdk.kotlin.services.lookoutvision.model.StartModelRequest
import aws.sdk.kotlin.services.lookoutvision.model.StartModelResponse
import aws.sdk.kotlin.services.lookoutvision.model.StopModelRequest
import aws.sdk.kotlin.services.lookoutvision.model.StopModelResponse
import aws.sdk.kotlin.services.lookoutvision.model.TagResourceRequest
import aws.sdk.kotlin.services.lookoutvision.model.TagResourceResponse
import aws.sdk.kotlin.services.lookoutvision.model.UntagResourceRequest
import aws.sdk.kotlin.services.lookoutvision.model.UntagResourceResponse
import aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesRequest
import aws.sdk.kotlin.services.lookoutvision.model.UpdateDatasetEntriesResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "LookoutVision"
public const val SdkVersion: String = "1.0.8"

/**
 * This is the Amazon Lookout for Vision API Reference. It provides descriptions of actions, data types, common parameters, and common errors.
 *
 * Amazon Lookout for Vision enables you to find visual defects in industrial products, accurately and at scale. It uses computer vision to identify missing components in an industrial product, damage to vehicles or structures, irregularities in production lines, and even minuscule defects in silicon wafers — or any other physical item where quality is important such as a missing capacitor on printed circuit boards.
 */
public interface LookoutVisionClient : SdkClient {
    /**
     * LookoutVisionClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LookoutVisionClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "LookoutVision",
                "LOOKOUTVISION",
                "lookoutvision",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LookoutVisionClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LookoutVisionClient = DefaultLookoutVisionClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LookoutVisionEndpointProvider = builder.endpointProvider ?: DefaultLookoutVisionEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LookoutVisionAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLookoutVisionAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "LookoutVision"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LookoutVisionEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LookoutVisionAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new dataset in an Amazon Lookout for Vision project. `CreateDataset` can create a training or a test dataset from a valid dataset source (`DatasetSource`).
     *
     * If you want a single dataset project, specify `train` for the value of `DatasetType`.
     *
     * To have a project with separate training and test datasets, call `CreateDataset` twice. On the first call, specify `train` for the value of `DatasetType`. On the second call, specify `test` for the value of `DatasetType`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateDataset` operation.
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a new version of a model within an an Amazon Lookout for Vision project. `CreateModel` is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
     *
     * To get the current status, check the `Status` field returned in the response from DescribeModel.
     *
     * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.
     *
     * After training completes, the evaluation metrics are stored at the location specified in `OutputConfig`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateModel` operation. If you want to tag your model, you also require permission to the `lookoutvision:TagResource` operation.
     */
    public suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateProject` operation.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Deletes an existing Amazon Lookout for Vision `dataset`.
     *
     * If your the project has a single dataset, you must create a new dataset before you can create a model.
     *
     * If you project has a training dataset and a test dataset consider the following.
     * + If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
     * + If you delete the training dataset, you must create a training dataset before you can create a model.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteDataset` operation.
     */
    public suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation.
     *
     * It might take a few seconds to delete a model. To determine if a model has been deleted, call ListModels and check if the version of the model (`ModelVersion`) is in the `Models` array.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteModel` operation.
     */
    public suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes an Amazon Lookout for Vision project.
     *
     * To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation.
     *
     * You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteProject` operation.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Describe an Amazon Lookout for Vision dataset.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeDataset` operation.
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Describes a version of an Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModel` operation.
     */
    public suspend fun describeModel(input: DescribeModelRequest): DescribeModelResponse

    /**
     * Describes an Amazon Lookout for Vision model packaging job.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModelPackagingJob` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    public suspend fun describeModelPackagingJob(input: DescribeModelPackagingJobRequest): DescribeModelPackagingJobResponse

    /**
     * Describes an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeProject` operation.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Detects anomalies in an image that you supply.
     *
     * The response from `DetectAnomalies` includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response also includes segmentation information for each type of anomaly found in the image.
     *
     * Before calling `DetectAnomalies`, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.
     *
     * For more information, see *Detecting anomalies in an image* in the Amazon Lookout for Vision developer guide.
     *
     * This operation requires permissions to perform the `lookoutvision:DetectAnomalies` operation.
     */
    public suspend fun detectAnomalies(input: DetectAnomaliesRequest): DetectAnomaliesResponse

    /**
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.
     *
     * This operation requires permissions to perform the `lookoutvision:ListDatasetEntries` operation.
     */
    public suspend fun listDatasetEntries(input: ListDatasetEntriesRequest): ListDatasetEntriesResponse

    /**
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModelPackagingJobs` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    public suspend fun listModelPackagingJobs(input: ListModelPackagingJobsRequest): ListModelPackagingJobsResponse

    /**
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     *
     * The `ListModels` operation is eventually consistent. Recent calls to `CreateModel` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModels` operation.
     */
    public suspend fun listModels(input: ListModelsRequest): ListModelsResponse

    /**
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call `ListProjects`.
     *
     * The `ListProjects` operation is eventually consistent. Recent calls to `CreateProject` and `DeleteProject` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListProjects` operation.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest { }): ListProjectsResponse

    /**
     * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:ListTagsForResource` operation.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel.
     *
     * A model is ready to use when its status is `HOSTED`.
     *
     * Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.
     *
     * You are charged for the amount of time that the model is running. To stop a running model, call StopModel.
     *
     * This operation requires permissions to perform the `lookoutvision:StartModel` operation.
     */
    public suspend fun startModel(input: StartModelRequest): StartModelResponse

    /**
     * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass.
     *
     * Use the DescribeModelPackagingJob API to determine the current status of the job. The model packaging job is complete if the value of `Status` is `SUCCEEDED`.
     *
     * To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass [CreateDeployment](https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html) API.
     *
     * This operation requires the following permissions:
     * + `lookoutvision:StartModelPackagingJob`
     * + `s3:PutObject`
     * + `s3:GetBucketLocation`
     * + `kms:GenerateDataKey`
     * + `greengrass:CreateComponentVersion`
     * + `greengrass:DescribeComponent`
     * + (Optional) `greengrass:TagResource`. Only required if you want to tag the component.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    public suspend fun startModelPackagingJob(input: StartModelPackagingJobRequest): StartModelPackagingJobResponse

    /**
     * Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.
     *
     * After the model hosting stops, the `Status` of the model is `TRAINED`.
     *
     * This operation requires permissions to perform the `lookoutvision:StopModel` operation.
     */
    public suspend fun stopModel(input: StopModelRequest): StopModelResponse

    /**
     * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:TagResource` operation.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:UntagResource` operation.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.
     *
     * To update an existing JSON Line, use the `source-ref` field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset.
     *
     * For more information, see *Defining JSON lines for anomaly classification* in the Amazon Lookout for Vision Developer Guide.
     *
     * The images you reference in the `source-ref` field of a JSON line, must be in the same S3 bucket as the existing images in the dataset.
     *
     * Updating a dataset might take a while to complete. To check the current status, call DescribeDataset and check the `Status` field in the response.
     *
     * This operation requires permissions to perform the `lookoutvision:UpdateDatasetEntries` operation.
     */
    public suspend fun updateDatasetEntries(input: UpdateDatasetEntriesRequest): UpdateDatasetEntriesResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LookoutVisionClient.withConfig(block: LookoutVisionClient.Config.Builder.() -> Unit): LookoutVisionClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLookoutVisionClient(newConfig)
}

/**
 * Creates a new dataset in an Amazon Lookout for Vision project. `CreateDataset` can create a training or a test dataset from a valid dataset source (`DatasetSource`).
 *
 * If you want a single dataset project, specify `train` for the value of `DatasetType`.
 *
 * To have a project with separate training and test datasets, call `CreateDataset` twice. On the first call, specify `train` for the value of `DatasetType`. On the second call, specify `test` for the value of `DatasetType`.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateDataset` operation.
 */
public suspend inline fun LookoutVisionClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a new version of a model within an an Amazon Lookout for Vision project. `CreateModel` is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
 *
 * To get the current status, check the `Status` field returned in the response from DescribeModel.
 *
 * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.
 *
 * After training completes, the evaluation metrics are stored at the location specified in `OutputConfig`.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateModel` operation. If you want to tag your model, you also require permission to the `lookoutvision:TagResource` operation.
 */
public suspend inline fun LookoutVisionClient.createModel(crossinline block: CreateModelRequest.Builder.() -> Unit): CreateModelResponse = createModel(CreateModelRequest.Builder().apply(block).build())

/**
 * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateProject` operation.
 */
public suspend inline fun LookoutVisionClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon Lookout for Vision `dataset`.
 *
 * If your the project has a single dataset, you must create a new dataset before you can create a model.
 *
 * If you project has a training dataset and a test dataset consider the following.
 * + If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
 * + If you delete the training dataset, you must create a training dataset before you can create a model.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteDataset` operation.
 */
public suspend inline fun LookoutVisionClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit): DeleteDatasetResponse = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation.
 *
 * It might take a few seconds to delete a model. To determine if a model has been deleted, call ListModels and check if the version of the model (`ModelVersion`) is in the `Models` array.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteModel` operation.
 */
public suspend inline fun LookoutVisionClient.deleteModel(crossinline block: DeleteModelRequest.Builder.() -> Unit): DeleteModelResponse = deleteModel(DeleteModelRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Lookout for Vision project.
 *
 * To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation.
 *
 * You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteProject` operation.
 */
public suspend inline fun LookoutVisionClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Describe an Amazon Lookout for Vision dataset.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeDataset` operation.
 */
public suspend inline fun LookoutVisionClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Describes a version of an Amazon Lookout for Vision model.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeModel` operation.
 */
public suspend inline fun LookoutVisionClient.describeModel(crossinline block: DescribeModelRequest.Builder.() -> Unit): DescribeModelResponse = describeModel(DescribeModelRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Lookout for Vision model packaging job.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeModelPackagingJob` operation.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
public suspend inline fun LookoutVisionClient.describeModelPackagingJob(crossinline block: DescribeModelPackagingJobRequest.Builder.() -> Unit): DescribeModelPackagingJobResponse = describeModelPackagingJob(DescribeModelPackagingJobRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Lookout for Vision project.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeProject` operation.
 */
public suspend inline fun LookoutVisionClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Detects anomalies in an image that you supply.
 *
 * The response from `DetectAnomalies` includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response also includes segmentation information for each type of anomaly found in the image.
 *
 * Before calling `DetectAnomalies`, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.
 *
 * For more information, see *Detecting anomalies in an image* in the Amazon Lookout for Vision developer guide.
 *
 * This operation requires permissions to perform the `lookoutvision:DetectAnomalies` operation.
 */
public suspend inline fun LookoutVisionClient.detectAnomalies(crossinline block: DetectAnomaliesRequest.Builder.() -> Unit): DetectAnomaliesResponse = detectAnomalies(DetectAnomaliesRequest.Builder().apply(block).build())

/**
 * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.
 *
 * This operation requires permissions to perform the `lookoutvision:ListDatasetEntries` operation.
 */
public suspend inline fun LookoutVisionClient.listDatasetEntries(crossinline block: ListDatasetEntriesRequest.Builder.() -> Unit): ListDatasetEntriesResponse = listDatasetEntries(ListDatasetEntriesRequest.Builder().apply(block).build())

/**
 * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
 *
 * This operation requires permissions to perform the `lookoutvision:ListModelPackagingJobs` operation.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
public suspend inline fun LookoutVisionClient.listModelPackagingJobs(crossinline block: ListModelPackagingJobsRequest.Builder.() -> Unit): ListModelPackagingJobsResponse = listModelPackagingJobs(ListModelPackagingJobsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a model in an Amazon Lookout for Vision project.
 *
 * The `ListModels` operation is eventually consistent. Recent calls to `CreateModel` might take a while to appear in the response from `ListProjects`.
 *
 * This operation requires permissions to perform the `lookoutvision:ListModels` operation.
 */
public suspend inline fun LookoutVisionClient.listModels(crossinline block: ListModelsRequest.Builder.() -> Unit): ListModelsResponse = listModels(ListModelsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call `ListProjects`.
 *
 * The `ListProjects` operation is eventually consistent. Recent calls to `CreateProject` and `DeleteProject` might take a while to appear in the response from `ListProjects`.
 *
 * This operation requires permissions to perform the `lookoutvision:ListProjects` operation.
 */
public suspend inline fun LookoutVisionClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
 *
 * This operation requires permissions to perform the `lookoutvision:ListTagsForResource` operation.
 */
public suspend inline fun LookoutVisionClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel.
 *
 * A model is ready to use when its status is `HOSTED`.
 *
 * Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.
 *
 * You are charged for the amount of time that the model is running. To stop a running model, call StopModel.
 *
 * This operation requires permissions to perform the `lookoutvision:StartModel` operation.
 */
public suspend inline fun LookoutVisionClient.startModel(crossinline block: StartModelRequest.Builder.() -> Unit): StartModelResponse = startModel(StartModelRequest.Builder().apply(block).build())

/**
 * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass.
 *
 * Use the DescribeModelPackagingJob API to determine the current status of the job. The model packaging job is complete if the value of `Status` is `SUCCEEDED`.
 *
 * To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass [CreateDeployment](https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html) API.
 *
 * This operation requires the following permissions:
 * + `lookoutvision:StartModelPackagingJob`
 * + `s3:PutObject`
 * + `s3:GetBucketLocation`
 * + `kms:GenerateDataKey`
 * + `greengrass:CreateComponentVersion`
 * + `greengrass:DescribeComponent`
 * + (Optional) `greengrass:TagResource`. Only required if you want to tag the component.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
public suspend inline fun LookoutVisionClient.startModelPackagingJob(crossinline block: StartModelPackagingJobRequest.Builder.() -> Unit): StartModelPackagingJobResponse = startModelPackagingJob(StartModelPackagingJobRequest.Builder().apply(block).build())

/**
 * Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.
 *
 * After the model hosting stops, the `Status` of the model is `TRAINED`.
 *
 * This operation requires permissions to perform the `lookoutvision:StopModel` operation.
 */
public suspend inline fun LookoutVisionClient.stopModel(crossinline block: StopModelRequest.Builder.() -> Unit): StopModelResponse = stopModel(StopModelRequest.Builder().apply(block).build())

/**
 * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
 *
 * This operation requires permissions to perform the `lookoutvision:TagResource` operation.
 */
public suspend inline fun LookoutVisionClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
 *
 * This operation requires permissions to perform the `lookoutvision:UntagResource` operation.
 */
public suspend inline fun LookoutVisionClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.
 *
 * To update an existing JSON Line, use the `source-ref` field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset.
 *
 * For more information, see *Defining JSON lines for anomaly classification* in the Amazon Lookout for Vision Developer Guide.
 *
 * The images you reference in the `source-ref` field of a JSON line, must be in the same S3 bucket as the existing images in the dataset.
 *
 * Updating a dataset might take a while to complete. To check the current status, call DescribeDataset and check the `Status` field in the response.
 *
 * This operation requires permissions to perform the `lookoutvision:UpdateDatasetEntries` operation.
 */
public suspend inline fun LookoutVisionClient.updateDatasetEntries(crossinline block: UpdateDatasetEntriesRequest.Builder.() -> Unit): UpdateDatasetEntriesResponse = updateDatasetEntries(UpdateDatasetEntriesRequest.Builder().apply(block).build())
