// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.lookoutvision.auth.LookoutVisionAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.lookoutvision.auth.LookoutVisionIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.lookoutvision.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.lookoutvision.model.*
import aws.sdk.kotlin.services.lookoutvision.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext


public const val ServiceApiVersion: String = "2020-11-20"

internal class DefaultLookoutVisionClient(override val config: LookoutVisionClient.Config) : LookoutVisionClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = LookoutVisionIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "lookoutvision")
        }
        toMap()
    }
    private val authSchemeAdapter = LookoutVisionAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.lookoutvision"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Creates a new dataset in an Amazon Lookout for Vision project. `CreateDataset` can create a training or a test dataset from a valid dataset source (`DatasetSource`).
     *
     * If you want a single dataset project, specify `train` for the value of `DatasetType`.
     *
     * To have a project with separate training and test datasets, call `CreateDataset` twice. On the first call, specify `train` for the value of `DatasetType`. On the second call, specify `test` for the value of `DatasetType`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateDataset` operation.
     */
    override suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse {
        val op = SdkHttpOperation.build<CreateDatasetRequest, CreateDatasetResponse> {
            serializer = CreateDatasetOperationSerializer()
            deserializer = CreateDatasetOperationDeserializer()
            operationName = "CreateDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of a model within an an Amazon Lookout for Vision project. `CreateModel` is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
     *
     * To get the current status, check the `Status` field returned in the response from DescribeModel.
     *
     * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.
     *
     * After training completes, the evaluation metrics are stored at the location specified in `OutputConfig`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateModel` operation. If you want to tag your model, you also require permission to the `lookoutvision:TagResource` operation.
     */
    override suspend fun createModel(input: CreateModelRequest): CreateModelResponse {
        val op = SdkHttpOperation.build<CreateModelRequest, CreateModelResponse> {
            serializer = CreateModelOperationSerializer()
            deserializer = CreateModelOperationDeserializer()
            operationName = "CreateModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateProject` operation.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            operationName = "CreateProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amazon Lookout for Vision `dataset`.
     *
     * If your the project has a single dataset, you must create a new dataset before you can create a model.
     *
     * If you project has a training dataset and a test dataset consider the following.
     * + If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
     * + If you delete the training dataset, you must create a training dataset before you can create a model.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteDataset` operation.
     */
    override suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse {
        val op = SdkHttpOperation.build<DeleteDatasetRequest, DeleteDatasetResponse> {
            serializer = DeleteDatasetOperationSerializer()
            deserializer = DeleteDatasetOperationDeserializer()
            operationName = "DeleteDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation.
     *
     * It might take a few seconds to delete a model. To determine if a model has been deleted, call ListModels and check if the version of the model (`ModelVersion`) is in the `Models` array.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteModel` operation.
     */
    override suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse {
        val op = SdkHttpOperation.build<DeleteModelRequest, DeleteModelResponse> {
            serializer = DeleteModelOperationSerializer()
            deserializer = DeleteModelOperationDeserializer()
            operationName = "DeleteModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Lookout for Vision project.
     *
     * To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation.
     *
     * You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteProject` operation.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            operationName = "DeleteProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe an Amazon Lookout for Vision dataset.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeDataset` operation.
     */
    override suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse {
        val op = SdkHttpOperation.build<DescribeDatasetRequest, DescribeDatasetResponse> {
            serializer = DescribeDatasetOperationSerializer()
            deserializer = DescribeDatasetOperationDeserializer()
            operationName = "DescribeDataset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a version of an Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModel` operation.
     */
    override suspend fun describeModel(input: DescribeModelRequest): DescribeModelResponse {
        val op = SdkHttpOperation.build<DescribeModelRequest, DescribeModelResponse> {
            serializer = DescribeModelOperationSerializer()
            deserializer = DescribeModelOperationDeserializer()
            operationName = "DescribeModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an Amazon Lookout for Vision model packaging job.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModelPackagingJob` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    override suspend fun describeModelPackagingJob(input: DescribeModelPackagingJobRequest): DescribeModelPackagingJobResponse {
        val op = SdkHttpOperation.build<DescribeModelPackagingJobRequest, DescribeModelPackagingJobResponse> {
            serializer = DescribeModelPackagingJobOperationSerializer()
            deserializer = DescribeModelPackagingJobOperationDeserializer()
            operationName = "DescribeModelPackagingJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeProject` operation.
     */
    override suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse {
        val op = SdkHttpOperation.build<DescribeProjectRequest, DescribeProjectResponse> {
            serializer = DescribeProjectOperationSerializer()
            deserializer = DescribeProjectOperationDeserializer()
            operationName = "DescribeProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detects anomalies in an image that you supply.
     *
     * The response from `DetectAnomalies` includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction. If the model is an image segmentation model, the response also includes segmentation information for each type of anomaly found in the image.
     *
     * Before calling `DetectAnomalies`, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.
     *
     * For more information, see *Detecting anomalies in an image* in the Amazon Lookout for Vision developer guide.
     *
     * This operation requires permissions to perform the `lookoutvision:DetectAnomalies` operation.
     */
    override suspend fun detectAnomalies(input: DetectAnomaliesRequest): DetectAnomaliesResponse {
        val op = SdkHttpOperation.build<DetectAnomaliesRequest, DetectAnomaliesResponse> {
            serializer = DetectAnomaliesOperationSerializer()
            deserializer = DetectAnomaliesOperationDeserializer()
            operationName = "DetectAnomalies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.
     *
     * This operation requires permissions to perform the `lookoutvision:ListDatasetEntries` operation.
     */
    override suspend fun listDatasetEntries(input: ListDatasetEntriesRequest): ListDatasetEntriesResponse {
        val op = SdkHttpOperation.build<ListDatasetEntriesRequest, ListDatasetEntriesResponse> {
            serializer = ListDatasetEntriesOperationSerializer()
            deserializer = ListDatasetEntriesOperationDeserializer()
            operationName = "ListDatasetEntries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModelPackagingJobs` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    override suspend fun listModelPackagingJobs(input: ListModelPackagingJobsRequest): ListModelPackagingJobsResponse {
        val op = SdkHttpOperation.build<ListModelPackagingJobsRequest, ListModelPackagingJobsResponse> {
            serializer = ListModelPackagingJobsOperationSerializer()
            deserializer = ListModelPackagingJobsOperationDeserializer()
            operationName = "ListModelPackagingJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     *
     * The `ListModels` operation is eventually consistent. Recent calls to `CreateModel` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModels` operation.
     */
    override suspend fun listModels(input: ListModelsRequest): ListModelsResponse {
        val op = SdkHttpOperation.build<ListModelsRequest, ListModelsResponse> {
            serializer = ListModelsOperationSerializer()
            deserializer = ListModelsOperationDeserializer()
            operationName = "ListModels"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Lookout for Vision projects in your AWS account that are in the AWS Region in which you call `ListProjects`.
     *
     * The `ListProjects` operation is eventually consistent. Recent calls to `CreateProject` and `DeleteProject` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListProjects` operation.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            operationName = "ListProjects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:ListTagsForResource` operation.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel.
     *
     * A model is ready to use when its status is `HOSTED`.
     *
     * Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.
     *
     * You are charged for the amount of time that the model is running. To stop a running model, call StopModel.
     *
     * This operation requires permissions to perform the `lookoutvision:StartModel` operation.
     */
    override suspend fun startModel(input: StartModelRequest): StartModelResponse {
        val op = SdkHttpOperation.build<StartModelRequest, StartModelResponse> {
            serializer = StartModelOperationSerializer()
            deserializer = StartModelOperationDeserializer()
            operationName = "StartModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass.
     *
     * Use the DescribeModelPackagingJob API to determine the current status of the job. The model packaging job is complete if the value of `Status` is `SUCCEEDED`.
     *
     * To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass [CreateDeployment](https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html) API.
     *
     * This operation requires the following permissions:
     * + `lookoutvision:StartModelPackagingJob`
     * + `s3:PutObject`
     * + `s3:GetBucketLocation`
     * + `kms:GenerateDataKey`
     * + `greengrass:CreateComponentVersion`
     * + `greengrass:DescribeComponent`
     * + (Optional) `greengrass:TagResource`. Only required if you want to tag the component.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    override suspend fun startModelPackagingJob(input: StartModelPackagingJobRequest): StartModelPackagingJobResponse {
        val op = SdkHttpOperation.build<StartModelPackagingJobRequest, StartModelPackagingJobResponse> {
            serializer = StartModelPackagingJobOperationSerializer()
            deserializer = StartModelPackagingJobOperationDeserializer()
            operationName = "StartModelPackagingJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.
     *
     * After the model hosting stops, the `Status` of the model is `TRAINED`.
     *
     * This operation requires permissions to perform the `lookoutvision:StopModel` operation.
     */
    override suspend fun stopModel(input: StopModelRequest): StopModelResponse {
        val op = SdkHttpOperation.build<StopModelRequest, StopModelResponse> {
            serializer = StopModelOperationSerializer()
            deserializer = StopModelOperationDeserializer()
            operationName = "StopModel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:TagResource` operation.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:UntagResource` operation.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.
     *
     * To update an existing JSON Line, use the `source-ref` field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset.
     *
     * For more information, see *Defining JSON lines for anomaly classification* in the Amazon Lookout for Vision Developer Guide.
     *
     * The images you reference in the `source-ref` field of a JSON line, must be in the same S3 bucket as the existing images in the dataset.
     *
     * Updating a dataset might take a while to complete. To check the current status, call DescribeDataset and check the `Status` field in the response.
     *
     * This operation requires permissions to perform the `lookoutvision:UpdateDatasetEntries` operation.
     */
    override suspend fun updateDatasetEntries(input: UpdateDatasetEntriesRequest): UpdateDatasetEntriesResponse {
        val op = SdkHttpOperation.build<UpdateDatasetEntriesRequest, UpdateDatasetEntriesResponse> {
            serializer = UpdateDatasetEntriesOperationSerializer()
            deserializer = UpdateDatasetEntriesOperationDeserializer()
            operationName = "UpdateDatasetEntries"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lookoutvision")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
    }
}
