// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.paginators

import aws.sdk.kotlin.services.lookoutvision.LookoutVisionClient
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListDatasetEntriesResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelPackagingJobsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListModelsResponse
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsRequest
import aws.sdk.kotlin.services.lookoutvision.model.ListProjectsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetEntriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
fun LookoutVisionClient.listDatasetEntriesPaginated(initialRequest: ListDatasetEntriesRequest): Flow<ListDatasetEntriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetEntriesPaginated.listDatasetEntries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
fun LookoutVisionClient.listDatasetEntriesPaginated(block: ListDatasetEntriesRequest.Builder.() -> Unit): Flow<ListDatasetEntriesResponse> =
    listDatasetEntriesPaginated(ListDatasetEntriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListModelPackagingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelPackagingJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelPackagingJobsResponse]
 */
fun LookoutVisionClient.listModelPackagingJobsPaginated(initialRequest: ListModelPackagingJobsRequest): Flow<ListModelPackagingJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelPackagingJobsPaginated.listModelPackagingJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListModelPackagingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelPackagingJobsResponse]
 */
fun LookoutVisionClient.listModelPackagingJobsPaginated(block: ListModelPackagingJobsRequest.Builder.() -> Unit): Flow<ListModelPackagingJobsResponse> =
    listModelPackagingJobsPaginated(ListModelPackagingJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelsResponse]
 */
fun LookoutVisionClient.listModelsPaginated(initialRequest: ListModelsRequest): Flow<ListModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelsPaginated.listModels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelsResponse]
 */
fun LookoutVisionClient.listModelsPaginated(block: ListModelsRequest.Builder.() -> Unit): Flow<ListModelsResponse> =
    listModelsPaginated(ListModelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
fun LookoutVisionClient.listProjectsPaginated(initialRequest: ListProjectsRequest): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
fun LookoutVisionClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())
