// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



class StartModelPackagingJobRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `StartModelPackagingJob` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `StartModelPackagingJob`. In this case, safely retry your call to `StartModelPackagingJob` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `StartModelPackagingJob`. An idempotency token is active for 8 hours.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The configuration for the model packaging job.
     */
    val configuration: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration? = builder.configuration
    /**
     * A description for the model packaging job.
     */
    val description: kotlin.String? = builder.description
    /**
     * A name for the model packaging job. If you don't supply a value, the service creates a job name for you.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The version of the model within the project that you want to package.
     */
    val modelVersion: kotlin.String? = builder.modelVersion
    /**
     * The name of the project which contains the version of the model that you want to package.
     */
    val projectName: kotlin.String? = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartModelPackagingJobRequest(")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("description=$description,")
        append("jobName=$jobName,")
        append("modelVersion=$modelVersion,")
        append("projectName=$projectName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (modelVersion?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartModelPackagingJobRequest

        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (jobName != other.jobName) return false
        if (modelVersion != other.modelVersion) return false
        if (projectName != other.projectName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `StartModelPackagingJob` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `StartModelPackagingJob`. In this case, safely retry your call to `StartModelPackagingJob` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `StartModelPackagingJob`. An idempotency token is active for 8 hours.
         */
        var clientToken: kotlin.String? = null
        /**
         * The configuration for the model packaging job.
         */
        var configuration: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration? = null
        /**
         * A description for the model packaging job.
         */
        var description: kotlin.String? = null
        /**
         * A name for the model packaging job. If you don't supply a value, the service creates a job name for you.
         */
        var jobName: kotlin.String? = null
        /**
         * The version of the model within the project that you want to package.
         */
        var modelVersion: kotlin.String? = null
        /**
         * The name of the project which contains the version of the model that you want to package.
         */
        var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobRequest) : this() {
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.description = x.description
            this.jobName = x.jobName
            this.modelVersion = x.modelVersion
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.StartModelPackagingJobRequest = StartModelPackagingJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.lookoutvision.model.ModelPackagingConfiguration.invoke(block)
        }
    }
}
