// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



/**
 * Information about the location of training output or the output of a model packaging job.
 */
class S3Location private constructor(builder: Builder) {
    /**
     * The S3 bucket that contains the training or model packaging job output. If you are training a model, the bucket must in your AWS account. If you use an S3 bucket for a model packaging job, the S3 bucket must be in the same AWS Region and AWS account in which you use AWS IoT Greengrass.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The path of the folder, within the S3 bucket, that contains the output.
     */
    val prefix: kotlin.String? = builder.prefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucket=$bucket,")
        append("prefix=$prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucket != other.bucket) return false
        if (prefix != other.prefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.S3Location = Builder(this).apply(block).build()

    class Builder {
        /**
         * The S3 bucket that contains the training or model packaging job output. If you are training a model, the bucket must in your AWS account. If you use an S3 bucket for a model packaging job, the S3 bucket must be in the same AWS Region and AWS account in which you use AWS IoT Greengrass.
         */
        var bucket: kotlin.String? = null
        /**
         * The path of the folder, within the S3 bucket, that contains the output.
         */
        var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.S3Location) : this() {
            this.bucket = x.bucket
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.S3Location = S3Location(this)
    }
}
