// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



/**
 * Configuration information for the AWS IoT Greengrass component created in a model packaging job. For more information, see StartModelPackagingJob.
 *
 * You can't specify a component with the same `ComponentName` and `Componentversion` as an existing component with the same component name and component version.
 */
class GreengrassConfiguration private constructor(builder: Builder) {
    /**
     * Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing Units (GPU) are supported. If you specify `TargetPlatform`, you must specify `CompilerOptions`. If you specify `TargetDevice`, don't specify `CompilerOptions`.
     *
     * For more information, see *Compiler options* in the Amazon Lookout for Vision Developer Guide.
     */
    val compilerOptions: kotlin.String? = builder.compilerOptions
    /**
     * A description for the AWS IoT Greengrass component.
     */
    val componentDescription: kotlin.String? = builder.componentDescription
    /**
     * A name for the AWS IoT Greengrass component.
     */
    val componentName: kotlin.String? = builder.componentName
    /**
     * A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of ` <i>Model Version</i>.0.0` is used.
     */
    val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * An S3 location in which Lookout for Vision stores the component artifacts.
     */
    val s3OutputLocation: aws.sdk.kotlin.services.lookoutvision.model.S3Location? = builder.s3OutputLocation
    /**
     * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The target device for the model. Currently the only supported value is `jetson_xavier`. If you specify `TargetDevice`, you can't specify `TargetPlatform`.
     */
    val targetDevice: aws.sdk.kotlin.services.lookoutvision.model.TargetDevice? = builder.targetDevice
    /**
     * The target platform for the model. If you specify `TargetPlatform`, you can't specify `TargetDevice`.
     */
    val targetPlatform: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform? = builder.targetPlatform

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.GreengrassConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GreengrassConfiguration(")
        append("compilerOptions=$compilerOptions,")
        append("componentDescription=$componentDescription,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("s3OutputLocation=$s3OutputLocation,")
        append("tags=$tags,")
        append("targetDevice=$targetDevice,")
        append("targetPlatform=$targetPlatform)")
    }

    override fun hashCode(): kotlin.Int {
        var result = compilerOptions?.hashCode() ?: 0
        result = 31 * result + (componentDescription?.hashCode() ?: 0)
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (s3OutputLocation?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDevice?.hashCode() ?: 0)
        result = 31 * result + (targetPlatform?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GreengrassConfiguration

        if (compilerOptions != other.compilerOptions) return false
        if (componentDescription != other.componentDescription) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (s3OutputLocation != other.s3OutputLocation) return false
        if (tags != other.tags) return false
        if (targetDevice != other.targetDevice) return false
        if (targetPlatform != other.targetPlatform) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.GreengrassConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing Units (GPU) are supported. If you specify `TargetPlatform`, you must specify `CompilerOptions`. If you specify `TargetDevice`, don't specify `CompilerOptions`.
         *
         * For more information, see *Compiler options* in the Amazon Lookout for Vision Developer Guide.
         */
        var compilerOptions: kotlin.String? = null
        /**
         * A description for the AWS IoT Greengrass component.
         */
        var componentDescription: kotlin.String? = null
        /**
         * A name for the AWS IoT Greengrass component.
         */
        var componentName: kotlin.String? = null
        /**
         * A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of ` <i>Model Version</i>.0.0` is used.
         */
        var componentVersion: kotlin.String? = null
        /**
         * An S3 location in which Lookout for Vision stores the component artifacts.
         */
        var s3OutputLocation: aws.sdk.kotlin.services.lookoutvision.model.S3Location? = null
        /**
         * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         */
        var tags: List<Tag>? = null
        /**
         * The target device for the model. Currently the only supported value is `jetson_xavier`. If you specify `TargetDevice`, you can't specify `TargetPlatform`.
         */
        var targetDevice: aws.sdk.kotlin.services.lookoutvision.model.TargetDevice? = null
        /**
         * The target platform for the model. If you specify `TargetPlatform`, you can't specify `TargetDevice`.
         */
        var targetPlatform: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.GreengrassConfiguration) : this() {
            this.compilerOptions = x.compilerOptions
            this.componentDescription = x.componentDescription
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.s3OutputLocation = x.s3OutputLocation
            this.tags = x.tags
            this.targetDevice = x.targetDevice
            this.targetPlatform = x.targetPlatform
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.GreengrassConfiguration = GreengrassConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.S3Location] inside the given [block]
         */
        fun s3OutputLocation(block: aws.sdk.kotlin.services.lookoutvision.model.S3Location.Builder.() -> kotlin.Unit) {
            this.s3OutputLocation = aws.sdk.kotlin.services.lookoutvision.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform] inside the given [block]
         */
        fun targetPlatform(block: aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform.Builder.() -> kotlin.Unit) {
            this.targetPlatform = aws.sdk.kotlin.services.lookoutvision.model.TargetPlatform.invoke(block)
        }
    }
}
