// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



class DeleteDatasetRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `DeleteDataset` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `DeleteDataset`. In this case, safely retry your call to `DeleteDataset` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `DeleteDataset`. An idempotency token is active for 8 hours.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The type of the dataset to delete. Specify `train` to delete the training dataset. Specify `test` to delete the test dataset. To delete the dataset in a single dataset project, specify `train`.
     */
    val datasetType: kotlin.String? = requireNotNull(builder.datasetType) { "A non-null value must be provided for datasetType" }
    /**
     * The name of the project that contains the dataset that you want to delete.
     */
    val projectName: kotlin.String? = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDatasetRequest(")
        append("clientToken=$clientToken,")
        append("datasetType=$datasetType,")
        append("projectName=$projectName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDatasetRequest

        if (clientToken != other.clientToken) return false
        if (datasetType != other.datasetType) return false
        if (projectName != other.projectName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `DeleteDataset` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `DeleteDataset`. In this case, safely retry your call to `DeleteDataset` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `DeleteDataset`. An idempotency token is active for 8 hours.
         */
        var clientToken: kotlin.String? = null
        /**
         * The type of the dataset to delete. Specify `train` to delete the training dataset. Specify `test` to delete the test dataset. To delete the dataset in a single dataset project, specify `train`.
         */
        var datasetType: kotlin.String? = null
        /**
         * The name of the project that contains the dataset that you want to delete.
         */
        var projectName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetRequest) : this() {
            this.clientToken = x.clientToken
            this.datasetType = x.datasetType
            this.projectName = x.projectName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.DeleteDatasetRequest = DeleteDatasetRequest(this)
    }
}
