// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The description for a dataset. For more information, see DescribeDataset.
 */
class DatasetDescription private constructor(builder: Builder) {
    /**
     * The Unix timestamp for the time and date that the dataset was created.
     */
    val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The type of the dataset. The value `train` represents a training dataset or single dataset project. The value `test` represents a test dataset.
     */
    val datasetType: kotlin.String? = builder.datasetType
    /**
     * Statistics about the images in a dataset.
     */
    val imageStats: aws.sdk.kotlin.services.lookoutvision.model.DatasetImageStats? = builder.imageStats
    /**
     * The Unix timestamp for the date and time that the dataset was last updated.
     */
    val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The name of the project that contains the dataset.
     */
    val projectName: kotlin.String? = builder.projectName
    /**
     * The status of the dataset.
     */
    val status: aws.sdk.kotlin.services.lookoutvision.model.DatasetStatus? = builder.status
    /**
     * The status message for the dataset.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.DatasetDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetDescription(")
        append("creationTimestamp=$creationTimestamp,")
        append("datasetType=$datasetType,")
        append("imageStats=$imageStats,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("projectName=$projectName,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (imageStats?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetDescription

        if (creationTimestamp != other.creationTimestamp) return false
        if (datasetType != other.datasetType) return false
        if (imageStats != other.imageStats) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (projectName != other.projectName) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.DatasetDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Unix timestamp for the time and date that the dataset was created.
         */
        var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of the dataset. The value `train` represents a training dataset or single dataset project. The value `test` represents a test dataset.
         */
        var datasetType: kotlin.String? = null
        /**
         * Statistics about the images in a dataset.
         */
        var imageStats: aws.sdk.kotlin.services.lookoutvision.model.DatasetImageStats? = null
        /**
         * The Unix timestamp for the date and time that the dataset was last updated.
         */
        var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the project that contains the dataset.
         */
        var projectName: kotlin.String? = null
        /**
         * The status of the dataset.
         */
        var status: aws.sdk.kotlin.services.lookoutvision.model.DatasetStatus? = null
        /**
         * The status message for the dataset.
         */
        var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.DatasetDescription) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.datasetType = x.datasetType
            this.imageStats = x.imageStats
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.projectName = x.projectName
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.DatasetDescription = DatasetDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.DatasetImageStats] inside the given [block]
         */
        fun imageStats(block: aws.sdk.kotlin.services.lookoutvision.model.DatasetImageStats.Builder.() -> kotlin.Unit) {
            this.imageStats = aws.sdk.kotlin.services.lookoutvision.model.DatasetImageStats.invoke(block)
        }
    }
}
