// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision.model



class CreateModelRequest private constructor(builder: Builder) {
    /**
     * ClientToken is an idempotency token that ensures a call to `CreateModel` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `CreateModel`. In this case, safely retry your call to `CreateModel` by using the same `ClientToken` parameter value.
     *
     * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases.
     *
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `CreateModel`. An idempotency token is active for 8 hours.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the version of the model.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The location where Amazon Lookout for Vision saves the training results.
     */
    val outputConfig: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig? = builder.outputConfig
    /**
     * The name of the project in which you want to create a model version.
     */
    val projectName: kotlin.String? = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * A set of tags (key-value pairs) that you want to attach to the model.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutvision.model.CreateModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputConfig=$outputConfig,")
        append("projectName=$projectName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputConfig != other.outputConfig) return false
        if (projectName != other.projectName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutvision.model.CreateModelRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * ClientToken is an idempotency token that ensures a call to `CreateModel` completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from `CreateModel`. In this case, safely retry your call to `CreateModel` by using the same `ClientToken` parameter value.
         *
         * If you don't supply a value for `ClientToken`, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases.
         *
         * An error occurs if the other input parameters are not the same as in the first request. Using a different value for `ClientToken` is considered a new call to `CreateModel`. An idempotency token is active for 8 hours.
         */
        var clientToken: kotlin.String? = null
        /**
         * A description for the version of the model.
         */
        var description: kotlin.String? = null
        /**
         * The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The location where Amazon Lookout for Vision saves the training results.
         */
        var outputConfig: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig? = null
        /**
         * The name of the project in which you want to create a model version.
         */
        var projectName: kotlin.String? = null
        /**
         * A set of tags (key-value pairs) that you want to attach to the model.
         */
        var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutvision.model.CreateModelRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.outputConfig = x.outputConfig
            this.projectName = x.projectName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutvision.model.CreateModelRequest = CreateModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutvision.model.OutputConfig] inside the given [block]
         */
        fun outputConfig(block: aws.sdk.kotlin.services.lookoutvision.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.lookoutvision.model.OutputConfig.invoke(block)
        }
    }
}
