// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutvision

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.lookoutvision.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.lookoutvision.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the Amazon Lookout for Vision API Reference. It provides descriptions of actions, data types, common parameters, and common errors.
 *
 * Amazon Lookout for Vision enables you to find visual defects in industrial products, accurately and at scale. It uses computer vision to identify missing components in an industrial product, damage to vehicles or structures, irregularities in production lines, and even minuscule defects in silicon wafers — or any other physical item where quality is important such as a missing capacitor on printed circuit boards.
 */
interface LookoutVisionClient : SdkClient {

    override val serviceName: String
        get() = "LookoutVision"
    /**
     * LookoutVisionClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): LookoutVisionClient {
            val config = Config.Builder().apply(block).build()
            return DefaultLookoutVisionClient(config)
        }

        operator fun invoke(config: Config): LookoutVisionClient = DefaultLookoutVisionClient(config)

        /**
         * Construct a [LookoutVisionClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LookoutVisionClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLookoutVisionClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new dataset in an Amazon Lookout for Vision project. `CreateDataset` can create a training or a test dataset from a valid dataset source (`DatasetSource`).
     *
     * If you want a single dataset project, specify `train` for the value of `DatasetType`.
     *
     * To have a project with separate training and test datasets, call `CreateDataset` twice. On the first call, specify `train` for the value of `DatasetType`. On the second call, specify `test` for the value of `DatasetType`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateDataset` operation.
     */
    suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a new version of a model within an an Amazon Lookout for Vision project. `CreateModel` is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
     *
     * To get the current status, check the `Status` field returned in the response from DescribeModel.
     *
     * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.
     *
     * After training completes, the evaluation metrics are stored at the location specified in `OutputConfig`.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateModel` operation. If you want to tag your model, you also require permission to the `lookoutvision:TagResource` operation.
     */
    suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset.
     *
     * This operation requires permissions to perform the `lookoutvision:CreateProject` operation.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Deletes an existing Amazon Lookout for Vision `dataset`.
     *
     * If your the project has a single dataset, you must create a new dataset before you can create a model.
     *
     * If you project has a training dataset and a test dataset consider the following.
     * + If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
     * + If you delete the training dataset, you must create a training dataset before you can create a model.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteDataset` operation.
     */
    suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation.
     *
     * It might take a few seconds to delete a model. To determine if a model has been deleted, call ListModels and check if the version of the model (`ModelVersion`) is in the `Models` array.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteModel` operation.
     */
    suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes an Amazon Lookout for Vision project.
     *
     * To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation.
     *
     * You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.
     *
     * This operation requires permissions to perform the `lookoutvision:DeleteProject` operation.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Describe an Amazon Lookout for Vision dataset.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeDataset` operation.
     */
    suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Describes a version of an Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModel` operation.
     */
    suspend fun describeModel(input: DescribeModelRequest): DescribeModelResponse

    /**
     * Describes an Amazon Lookout for Vision model packaging job.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeModelPackagingJob` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    suspend fun describeModelPackagingJob(input: DescribeModelPackagingJobRequest): DescribeModelPackagingJobResponse

    /**
     * Describes an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:DescribeProject` operation.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Detects anomalies in an image that you supply.
     *
     * The response from `DetectAnomalies` includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction.
     *
     * Before calling `DetectAnomalies`, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.
     *
     * This operation requires permissions to perform the `lookoutvision:DetectAnomalies` operation.
     */
    suspend fun detectAnomalies(input: DetectAnomaliesRequest): DetectAnomaliesResponse

    /**
     * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.
     *
     * This operation requires permissions to perform the `lookoutvision:ListDatasetEntries` operation.
     */
    suspend fun listDatasetEntries(input: ListDatasetEntriesRequest): ListDatasetEntriesResponse

    /**
     * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModelPackagingJobs` operation.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    suspend fun listModelPackagingJobs(input: ListModelPackagingJobsRequest): ListModelPackagingJobsResponse

    /**
     * Lists the versions of a model in an Amazon Lookout for Vision project.
     *
     * The `ListModels` operation is eventually consistent. Recent calls to `CreateModel` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListModels` operation.
     */
    suspend fun listModels(input: ListModelsRequest): ListModelsResponse

    /**
     * Lists the Amazon Lookout for Vision projects in your AWS account.
     *
     * The `ListProjects` operation is eventually consistent. Recent calls to `CreateProject` and `DeleteProject` might take a while to appear in the response from `ListProjects`.
     *
     * This operation requires permissions to perform the `lookoutvision:ListProjects` operation.
     */
    suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
     *
     * This operation requires permissions to perform the `lookoutvision:ListTagsForResource` operation.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel.
     *
     * A model is ready to use when its status is `HOSTED`.
     *
     * Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.
     *
     * You are charged for the amount of time that the model is running. To stop a running model, call StopModel.
     *
     * This operation requires permissions to perform the `lookoutvision:StartModel` operation.
     */
    suspend fun startModel(input: StartModelRequest): StartModelResponse

    /**
     * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass.
     *
     * Use the DescribeModelPackagingJob API to determine the current status of the job. The model packaging job is complete if the value of `Status` is `SUCCEEDED`.
     *
     * To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass [CreateDeployment](https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html) API.
     *
     * This operation requires the following permissions:
     * + `lookoutvision:StartModelPackagingJob`
     * + `s3:PutObject`
     * + `s3:GetBucketLocation`
     * + `greengrass:CreateComponentVersion`
     * + `greengrass:DescribeComponent`
     * + (Optional) `greengrass:TagResource`. Only required if you want to tag the component.
     *
     * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
     */
    suspend fun startModelPackagingJob(input: StartModelPackagingJobRequest): StartModelPackagingJobResponse

    /**
     * Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.
     *
     * After the model hosting stops, the `Status` of the model is `TRAINED`.
     *
     * This operation requires permissions to perform the `lookoutvision:StopModel` operation.
     */
    suspend fun stopModel(input: StopModelRequest): StopModelResponse

    /**
     * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:TagResource` operation.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
     *
     * This operation requires permissions to perform the `lookoutvision:UntagResource` operation.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.
     *
     * To update an existing JSON Line, use the `source-ref` field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset.
     *
     * For more information, see *Defining JSON lines for anomaly classification* in the Amazon Lookout for Vision Developer Guide.
     *
     * The images you reference in the `source-ref` field of a JSON line, must be in the same S3 bucket as the existing images in the dataset.
     *
     * Updating a dataset might take a while to complete. To check the current status, call DescribeDataset and check the `Status` field in the response.
     *
     * This operation requires permissions to perform the `lookoutvision:UpdateDatasetEntries` operation.
     */
    suspend fun updateDatasetEntries(input: UpdateDatasetEntriesRequest): UpdateDatasetEntriesResponse
}

/**
 * Creates a new dataset in an Amazon Lookout for Vision project. `CreateDataset` can create a training or a test dataset from a valid dataset source (`DatasetSource`).
 *
 * If you want a single dataset project, specify `train` for the value of `DatasetType`.
 *
 * To have a project with separate training and test datasets, call `CreateDataset` twice. On the first call, specify `train` for the value of `DatasetType`. On the second call, specify `test` for the value of `DatasetType`.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateDataset` operation.
 */
suspend inline fun LookoutVisionClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit) = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a new version of a model within an an Amazon Lookout for Vision project. `CreateModel` is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model.
 *
 * To get the current status, check the `Status` field returned in the response from DescribeModel.
 *
 * If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model.
 *
 * After training completes, the evaluation metrics are stored at the location specified in `OutputConfig`.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateModel` operation. If you want to tag your model, you also require permission to the `lookoutvision:TagResource` operation.
 */
suspend inline fun LookoutVisionClient.createModel(crossinline block: CreateModelRequest.Builder.() -> Unit) = createModel(CreateModelRequest.Builder().apply(block).build())

/**
 * Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling CreateDataset.
 *
 * This operation requires permissions to perform the `lookoutvision:CreateProject` operation.
 */
suspend inline fun LookoutVisionClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit) = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon Lookout for Vision `dataset`.
 *
 * If your the project has a single dataset, you must create a new dataset before you can create a model.
 *
 * If you project has a training dataset and a test dataset consider the following.
 * + If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.
 * + If you delete the training dataset, you must create a training dataset before you can create a model.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteDataset` operation.
 */
suspend inline fun LookoutVisionClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit) = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the StopModel operation.
 *
 * It might take a few seconds to delete a model. To determine if a model has been deleted, call ListModels and check if the version of the model (`ModelVersion`) is in the `Models` array.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteModel` operation.
 */
suspend inline fun LookoutVisionClient.deleteModel(crossinline block: DeleteModelRequest.Builder.() -> Unit) = deleteModel(DeleteModelRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Lookout for Vision project.
 *
 * To delete a project, you must first delete each version of the model associated with the project. To delete a model use the DeleteModel operation.
 *
 * You also have to delete the dataset(s) associated with the model. For more information, see DeleteDataset. The images referenced by the training and test datasets aren't deleted.
 *
 * This operation requires permissions to perform the `lookoutvision:DeleteProject` operation.
 */
suspend inline fun LookoutVisionClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit) = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Describe an Amazon Lookout for Vision dataset.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeDataset` operation.
 */
suspend inline fun LookoutVisionClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit) = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Describes a version of an Amazon Lookout for Vision model.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeModel` operation.
 */
suspend inline fun LookoutVisionClient.describeModel(crossinline block: DescribeModelRequest.Builder.() -> Unit) = describeModel(DescribeModelRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Lookout for Vision model packaging job.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeModelPackagingJob` operation.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
suspend inline fun LookoutVisionClient.describeModelPackagingJob(crossinline block: DescribeModelPackagingJobRequest.Builder.() -> Unit) = describeModelPackagingJob(DescribeModelPackagingJobRequest.Builder().apply(block).build())

/**
 * Describes an Amazon Lookout for Vision project.
 *
 * This operation requires permissions to perform the `lookoutvision:DescribeProject` operation.
 */
suspend inline fun LookoutVisionClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit) = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Detects anomalies in an image that you supply.
 *
 * The response from `DetectAnomalies` includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction.
 *
 * Before calling `DetectAnomalies`, you must first start your model with the StartModel operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the StopModel operation to stop your model.
 *
 * This operation requires permissions to perform the `lookoutvision:DetectAnomalies` operation.
 */
suspend inline fun LookoutVisionClient.detectAnomalies(crossinline block: DetectAnomaliesRequest.Builder.() -> Unit) = detectAnomalies(DetectAnomaliesRequest.Builder().apply(block).build())

/**
 * Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.
 *
 * This operation requires permissions to perform the `lookoutvision:ListDatasetEntries` operation.
 */
suspend inline fun LookoutVisionClient.listDatasetEntries(crossinline block: ListDatasetEntriesRequest.Builder.() -> Unit) = listDatasetEntries(ListDatasetEntriesRequest.Builder().apply(block).build())

/**
 * Lists the model packaging jobs created for an Amazon Lookout for Vision project.
 *
 * This operation requires permissions to perform the `lookoutvision:ListModelPackagingJobs` operation.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
suspend inline fun LookoutVisionClient.listModelPackagingJobs(crossinline block: ListModelPackagingJobsRequest.Builder.() -> Unit) = listModelPackagingJobs(ListModelPackagingJobsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a model in an Amazon Lookout for Vision project.
 *
 * The `ListModels` operation is eventually consistent. Recent calls to `CreateModel` might take a while to appear in the response from `ListProjects`.
 *
 * This operation requires permissions to perform the `lookoutvision:ListModels` operation.
 */
suspend inline fun LookoutVisionClient.listModels(crossinline block: ListModelsRequest.Builder.() -> Unit) = listModels(ListModelsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Lookout for Vision projects in your AWS account.
 *
 * The `ListProjects` operation is eventually consistent. Recent calls to `CreateProject` and `DeleteProject` might take a while to appear in the response from `ListProjects`.
 *
 * This operation requires permissions to perform the `lookoutvision:ListProjects` operation.
 */
suspend inline fun LookoutVisionClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit) = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags attached to the specified Amazon Lookout for Vision model.
 *
 * This operation requires permissions to perform the `lookoutvision:ListTagsForResource` operation.
 */
suspend inline fun LookoutVisionClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use DescribeModel.
 *
 * A model is ready to use when its status is `HOSTED`.
 *
 * Once the model is running, you can detect custom labels in new images by calling DetectAnomalies.
 *
 * You are charged for the amount of time that the model is running. To stop a running model, call StopModel.
 *
 * This operation requires permissions to perform the `lookoutvision:StartModel` operation.
 */
suspend inline fun LookoutVisionClient.startModel(crossinline block: StartModelRequest.Builder.() -> Unit) = startModel(StartModelRequest.Builder().apply(block).build())

/**
 * Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass.
 *
 * Use the DescribeModelPackagingJob API to determine the current status of the job. The model packaging job is complete if the value of `Status` is `SUCCEEDED`.
 *
 * To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass [CreateDeployment](https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html) API.
 *
 * This operation requires the following permissions:
 * + `lookoutvision:StartModelPackagingJob`
 * + `s3:PutObject`
 * + `s3:GetBucketLocation`
 * + `greengrass:CreateComponentVersion`
 * + `greengrass:DescribeComponent`
 * + (Optional) `greengrass:TagResource`. Only required if you want to tag the component.
 *
 * For more information, see *Using your Amazon Lookout for Vision model on an edge device* in the Amazon Lookout for Vision Developer Guide.
 */
suspend inline fun LookoutVisionClient.startModelPackagingJob(crossinline block: StartModelPackagingJobRequest.Builder.() -> Unit) = startModelPackagingJob(StartModelPackagingJobRequest.Builder().apply(block).build())

/**
 * Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call DescribeModel.
 *
 * After the model hosting stops, the `Status` of the model is `TRAINED`.
 *
 * This operation requires permissions to perform the `lookoutvision:StopModel` operation.
 */
suspend inline fun LookoutVisionClient.stopModel(crossinline block: StopModelRequest.Builder.() -> Unit) = stopModel(StopModelRequest.Builder().apply(block).build())

/**
 * Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
 *
 * This operation requires permissions to perform the `lookoutvision:TagResource` operation.
 */
suspend inline fun LookoutVisionClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from an Amazon Lookout for Vision model. For more information, see *Tagging a model* in the *Amazon Lookout for Vision Developer Guide*.
 *
 * This operation requires permissions to perform the `lookoutvision:UntagResource` operation.
 */
suspend inline fun LookoutVisionClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.
 *
 * To update an existing JSON Line, use the `source-ref` field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset.
 *
 * For more information, see *Defining JSON lines for anomaly classification* in the Amazon Lookout for Vision Developer Guide.
 *
 * The images you reference in the `source-ref` field of a JSON line, must be in the same S3 bucket as the existing images in the dataset.
 *
 * Updating a dataset might take a while to complete. To check the current status, call DescribeDataset and check the `Status` field in the response.
 *
 * This operation requires permissions to perform the `lookoutvision:UpdateDatasetEntries` operation.
 */
suspend inline fun LookoutVisionClient.updateDatasetEntries(crossinline block: UpdateDatasetEntriesRequest.Builder.() -> Unit) = updateDatasetEntries(UpdateDatasetEntriesRequest.Builder().apply(block).build())
