// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.serde

import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.LookoutMetricsException
import aws.sdk.kotlin.services.lookoutmetrics.model.TimeSeries
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAnomalyGroupTimeSeriesOperationDeserializer: HttpDeserializer.NonStreaming<ListAnomalyGroupTimeSeriesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListAnomalyGroupTimeSeriesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAnomalyGroupTimeSeriesError(context, call, payload)
        }
        val builder = ListAnomalyGroupTimeSeriesResponse.Builder()

        if (payload != null) {
            deserializeListAnomalyGroupTimeSeriesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListAnomalyGroupTimeSeriesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LookoutMetricsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LookoutMetricsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnomalyGroupTimeSeriesOperationBody(builder: ListAnomalyGroupTimeSeriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnomalyGroupId"))
    val METRICNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MetricName"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TIMESERIESLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TimeSeriesList"))
    val TIMESTAMPLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TimestampList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYGROUPID_DESCRIPTOR)
        field(METRICNAME_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TIMESERIESLIST_DESCRIPTOR)
        field(TIMESTAMPLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYGROUPID_DESCRIPTOR.index -> builder.anomalyGroupId = deserializeString()
                METRICNAME_DESCRIPTOR.index -> builder.metricName = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TIMESERIESLIST_DESCRIPTOR.index -> builder.timeSeriesList =
                    deserializer.deserializeList(TIMESERIESLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeries>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMESTAMPLIST_DESCRIPTOR.index -> builder.timestampList =
                    deserializer.deserializeList(TIMESTAMPLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
