// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.serde

import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeMetricSetResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.Frequency
import aws.sdk.kotlin.services.lookoutmetrics.model.LookoutMetricsException
import aws.sdk.kotlin.services.lookoutmetrics.model.Metric
import aws.sdk.kotlin.services.lookoutmetrics.model.MetricSetDimensionFilter
import aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource
import aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeMetricSetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMetricSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMetricSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMetricSetError(context, call, payload)
        }
        val builder = DescribeMetricSetResponse.Builder()

        if (payload != null) {
            deserializeDescribeMetricSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMetricSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LookoutMetricsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LookoutMetricsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMetricSetOperationBody(builder: DescribeMetricSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYDETECTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnomalyDetectorArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DIMENSIONFILTERLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DimensionFilterList"))
    val DIMENSIONLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DimensionList"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val METRICLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MetricList"))
    val METRICSETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MetricSetArn"))
    val METRICSETDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MetricSetDescription"))
    val METRICSETFREQUENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MetricSetFrequency"))
    val METRICSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MetricSetName"))
    val METRICSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetricSource"))
    val OFFSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Offset"))
    val TIMESTAMPCOLUMN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimestampColumn"))
    val TIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timezone"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYDETECTORARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DIMENSIONFILTERLIST_DESCRIPTOR)
        field(DIMENSIONLIST_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(METRICLIST_DESCRIPTOR)
        field(METRICSETARN_DESCRIPTOR)
        field(METRICSETDESCRIPTION_DESCRIPTOR)
        field(METRICSETFREQUENCY_DESCRIPTOR)
        field(METRICSETNAME_DESCRIPTOR)
        field(METRICSOURCE_DESCRIPTOR)
        field(OFFSET_DESCRIPTOR)
        field(TIMESTAMPCOLUMN_DESCRIPTOR)
        field(TIMEZONE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYDETECTORARN_DESCRIPTOR.index -> builder.anomalyDetectorArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DIMENSIONFILTERLIST_DESCRIPTOR.index -> builder.dimensionFilterList =
                    deserializer.deserializeList(DIMENSIONFILTERLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<MetricSetDimensionFilter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricSetDimensionFilterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DIMENSIONLIST_DESCRIPTOR.index -> builder.dimensionList =
                    deserializer.deserializeList(DIMENSIONLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                METRICLIST_DESCRIPTOR.index -> builder.metricList =
                    deserializer.deserializeList(METRICLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Metric>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetricDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                METRICSETARN_DESCRIPTOR.index -> builder.metricSetArn = deserializeString()
                METRICSETDESCRIPTION_DESCRIPTOR.index -> builder.metricSetDescription = deserializeString()
                METRICSETFREQUENCY_DESCRIPTOR.index -> builder.metricSetFrequency = deserializeString().let { Frequency.fromValue(it) }
                METRICSETNAME_DESCRIPTOR.index -> builder.metricSetName = deserializeString()
                METRICSOURCE_DESCRIPTOR.index -> builder.metricSource = deserializeMetricSourceDocument(deserializer)
                OFFSET_DESCRIPTOR.index -> builder.offset = deserializeInt()
                TIMESTAMPCOLUMN_DESCRIPTOR.index -> builder.timestampColumn = deserializeTimestampColumnDocument(deserializer)
                TIMEZONE_DESCRIPTOR.index -> builder.timezone = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
