// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the Amazon Redshift database configuration.
 */
public class RedshiftSourceConfig private constructor(builder: Builder) {
    /**
     * A string identifying the Redshift cluster.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the database host.
     */
    public val databaseHost: kotlin.String? = builder.databaseHost
    /**
     * The Redshift database name.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The port number where the database can be accessed.
     */
    public val databasePort: kotlin.Int? = builder.databasePort
    /**
     * The Amazon Resource Name (ARN) of the role providing access to the database.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
     */
    public val secretManagerArn: kotlin.String? = builder.secretManagerArn
    /**
     * The table name of the Redshift database.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.lookoutmetrics.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.RedshiftSourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftSourceConfig(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("databaseHost=$databaseHost,")
        append("databaseName=$databaseName,")
        append("databasePort=$databasePort,")
        append("roleArn=$roleArn,")
        append("secretManagerArn=$secretManagerArn,")
        append("tableName=$tableName,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (databaseHost?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (databasePort ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (secretManagerArn?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftSourceConfig

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (databaseHost != other.databaseHost) return false
        if (databaseName != other.databaseName) return false
        if (databasePort != other.databasePort) return false
        if (roleArn != other.roleArn) return false
        if (secretManagerArn != other.secretManagerArn) return false
        if (tableName != other.tableName) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.RedshiftSourceConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string identifying the Redshift cluster.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the database host.
         */
        public var databaseHost: kotlin.String? = null
        /**
         * The Redshift database name.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The port number where the database can be accessed.
         */
        public var databasePort: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the role providing access to the database.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
         */
        public var secretManagerArn: kotlin.String? = null
        /**
         * The table name of the Redshift database.
         */
        public var tableName: kotlin.String? = null
        /**
         * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.lookoutmetrics.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.RedshiftSourceConfig) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.databaseHost = x.databaseHost
            this.databaseName = x.databaseName
            this.databasePort = x.databasePort
            this.roleArn = x.roleArn
            this.secretManagerArn = x.secretManagerArn
            this.tableName = x.tableName
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.RedshiftSourceConfig = RedshiftSourceConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.lookoutmetrics.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.lookoutmetrics.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
