// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a dataset.
 */
public class MetricSetSummary private constructor(builder: Builder) {
    /**
     * The ARN of the detector to which the dataset belongs.
     */
    public val anomalyDetectorArn: kotlin.String? = builder.anomalyDetectorArn
    /**
     * The time at which the dataset was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time at which the dataset was last modified.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * The ARN of the dataset.
     */
    public val metricSetArn: kotlin.String? = builder.metricSetArn
    /**
     * The description of the dataset.
     */
    public val metricSetDescription: kotlin.String? = builder.metricSetDescription
    /**
     * The name of the dataset.
     */
    public val metricSetName: kotlin.String? = builder.metricSetName
    /**
     * The dataset's [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.MetricSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricSetSummary(")
        append("anomalyDetectorArn=$anomalyDetectorArn,")
        append("creationTime=$creationTime,")
        append("lastModificationTime=$lastModificationTime,")
        append("metricSetArn=$metricSetArn,")
        append("metricSetDescription=$metricSetDescription,")
        append("metricSetName=$metricSetName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyDetectorArn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (metricSetArn?.hashCode() ?: 0)
        result = 31 * result + (metricSetDescription?.hashCode() ?: 0)
        result = 31 * result + (metricSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricSetSummary

        if (anomalyDetectorArn != other.anomalyDetectorArn) return false
        if (creationTime != other.creationTime) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (metricSetArn != other.metricSetArn) return false
        if (metricSetDescription != other.metricSetDescription) return false
        if (metricSetName != other.metricSetName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.MetricSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the detector to which the dataset belongs.
         */
        public var anomalyDetectorArn: kotlin.String? = null
        /**
         * The time at which the dataset was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the dataset was last modified.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the dataset.
         */
        public var metricSetArn: kotlin.String? = null
        /**
         * The description of the dataset.
         */
        public var metricSetDescription: kotlin.String? = null
        /**
         * The name of the dataset.
         */
        public var metricSetName: kotlin.String? = null
        /**
         * The dataset's [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.MetricSetSummary) : this() {
            this.anomalyDetectorArn = x.anomalyDetectorArn
            this.creationTime = x.creationTime
            this.lastModificationTime = x.lastModificationTime
            this.metricSetArn = x.metricSetArn
            this.metricSetDescription = x.metricSetDescription
            this.metricSetName = x.metricSetName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.MetricSetSummary = MetricSetSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
