// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.
 */
public class InterMetricImpactDetails private constructor(builder: Builder) {
    /**
     * The ID of the anomaly group.
     */
    public val anomalyGroupId: kotlin.String? = builder.anomalyGroupId
    /**
     * For potential causes (`CAUSE_OF_INPUT_ANOMALY_GROUP`), the percentage contribution the measure has in causing the anomalies.
     */
    public val contributionPercentage: kotlin.Double? = builder.contributionPercentage
    /**
     * The name of the measure.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * Whether a measure is a potential cause of the anomaly group (`CAUSE_OF_INPUT_ANOMALY_GROUP`), or whether the measure is impacted by the anomaly group (`EFFECT_OF_INPUT_ANOMALY_GROUP`).
     */
    public val relationshipType: aws.sdk.kotlin.services.lookoutmetrics.model.RelationshipType? = builder.relationshipType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.InterMetricImpactDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InterMetricImpactDetails(")
        append("anomalyGroupId=$anomalyGroupId,")
        append("contributionPercentage=$contributionPercentage,")
        append("metricName=$metricName,")
        append("relationshipType=$relationshipType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyGroupId?.hashCode() ?: 0
        result = 31 * result + (contributionPercentage?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (relationshipType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InterMetricImpactDetails

        if (anomalyGroupId != other.anomalyGroupId) return false
        if (contributionPercentage != other.contributionPercentage) return false
        if (metricName != other.metricName) return false
        if (relationshipType != other.relationshipType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.InterMetricImpactDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the anomaly group.
         */
        public var anomalyGroupId: kotlin.String? = null
        /**
         * For potential causes (`CAUSE_OF_INPUT_ANOMALY_GROUP`), the percentage contribution the measure has in causing the anomalies.
         */
        public var contributionPercentage: kotlin.Double? = null
        /**
         * The name of the measure.
         */
        public var metricName: kotlin.String? = null
        /**
         * Whether a measure is a potential cause of the anomaly group (`CAUSE_OF_INPUT_ANOMALY_GROUP`), or whether the measure is impacted by the anomaly group (`EFFECT_OF_INPUT_ANOMALY_GROUP`).
         */
        public var relationshipType: aws.sdk.kotlin.services.lookoutmetrics.model.RelationshipType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.InterMetricImpactDetails) : this() {
            this.anomalyGroupId = x.anomalyGroupId
            this.contributionPercentage = x.contributionPercentage
            this.metricName = x.metricName
            this.relationshipType = x.relationshipType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.InterMetricImpactDetails = InterMetricImpactDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
