// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAlertRequest private constructor(builder: Builder) {
    /**
     * Action that will be triggered when there is an alert.
     */
    public val action: aws.sdk.kotlin.services.lookoutmetrics.model.Action? = builder.action
    /**
     * A description of the alert.
     */
    public val alertDescription: kotlin.String? = builder.alertDescription
    /**
     * The configuration of the alert filters, containing MetricList and DimensionFilterList.
     */
    public val alertFilters: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters? = builder.alertFilters
    /**
     * The name of the alert.
     */
    public val alertName: kotlin.String? = builder.alertName
    /**
     * An integer from 0 to 100 specifying the alert sensitivity threshold.
     */
    public val alertSensitivityThreshold: kotlin.Int? = builder.alertSensitivityThreshold
    /**
     * The ARN of the detector to which the alert is attached.
     */
    public val anomalyDetectorArn: kotlin.String? = builder.anomalyDetectorArn
    /**
     * A list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to apply to the alert.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAlertRequest(")
        append("action=$action,")
        append("alertDescription=$alertDescription,")
        append("alertFilters=$alertFilters,")
        append("alertName=$alertName,")
        append("alertSensitivityThreshold=$alertSensitivityThreshold,")
        append("anomalyDetectorArn=$anomalyDetectorArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (alertDescription?.hashCode() ?: 0)
        result = 31 * result + (alertFilters?.hashCode() ?: 0)
        result = 31 * result + (alertName?.hashCode() ?: 0)
        result = 31 * result + (alertSensitivityThreshold ?: 0)
        result = 31 * result + (anomalyDetectorArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAlertRequest

        if (action != other.action) return false
        if (alertDescription != other.alertDescription) return false
        if (alertFilters != other.alertFilters) return false
        if (alertName != other.alertName) return false
        if (alertSensitivityThreshold != other.alertSensitivityThreshold) return false
        if (anomalyDetectorArn != other.anomalyDetectorArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Action that will be triggered when there is an alert.
         */
        public var action: aws.sdk.kotlin.services.lookoutmetrics.model.Action? = null
        /**
         * A description of the alert.
         */
        public var alertDescription: kotlin.String? = null
        /**
         * The configuration of the alert filters, containing MetricList and DimensionFilterList.
         */
        public var alertFilters: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters? = null
        /**
         * The name of the alert.
         */
        public var alertName: kotlin.String? = null
        /**
         * An integer from 0 to 100 specifying the alert sensitivity threshold.
         */
        public var alertSensitivityThreshold: kotlin.Int? = null
        /**
         * The ARN of the detector to which the alert is attached.
         */
        public var anomalyDetectorArn: kotlin.String? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to apply to the alert.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertRequest) : this() {
            this.action = x.action
            this.alertDescription = x.alertDescription
            this.alertFilters = x.alertFilters
            this.alertName = x.alertName
            this.alertSensitivityThreshold = x.alertSensitivityThreshold
            this.anomalyDetectorArn = x.anomalyDetectorArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertRequest = CreateAlertRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.Action] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.lookoutmetrics.model.Action.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.lookoutmetrics.model.Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters] inside the given [block]
         */
        public fun alertFilters(block: aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters.Builder.() -> kotlin.Unit) {
            this.alertFilters = aws.sdk.kotlin.services.lookoutmetrics.model.AlertFilters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
