// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.serde

import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyDetectorSummary
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyDetectorsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.LookoutMetricsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAnomalyDetectorsOperationDeserializer: HttpDeserialize<ListAnomalyDetectorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListAnomalyDetectorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAnomalyDetectorsError(context, call)
        }
        val builder = ListAnomalyDetectorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAnomalyDetectorsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListAnomalyDetectorsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LookoutMetricsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LookoutMetricsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnomalyDetectorsOperationBody(builder: ListAnomalyDetectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYDETECTORSUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AnomalyDetectorSummaryList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYDETECTORSUMMARYLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYDETECTORSUMMARYLIST_DESCRIPTOR.index -> builder.anomalyDetectorSummaryList =
                    deserializer.deserializeList(ANOMALYDETECTORSUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<AnomalyDetectorSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalyDetectorSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
