// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.lookoutmetrics.auth.DefaultLookoutMetricsAuthSchemeProvider
import aws.sdk.kotlin.services.lookoutmetrics.auth.LookoutMetricsAuthSchemeProvider
import aws.sdk.kotlin.services.lookoutmetrics.endpoints.DefaultLookoutMetricsEndpointProvider
import aws.sdk.kotlin.services.lookoutmetrics.endpoints.LookoutMetricsEndpointParameters
import aws.sdk.kotlin.services.lookoutmetrics.endpoints.LookoutMetricsEndpointProvider
import aws.sdk.kotlin.services.lookoutmetrics.model.ActivateAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ActivateAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.BackTestAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.BackTestAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateAlertResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DeactivateAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DeactivateAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DeleteAlertRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DeleteAlertResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DeleteAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DeleteAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAlertRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAlertResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeMetricSetRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeMetricSetResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.DetectMetricSetConfigRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DetectMetricSetConfigResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.GetAnomalyGroupRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.GetAnomalyGroupResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.GetDataQualityMetricsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.GetDataQualityMetricsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.GetFeedbackRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.GetFeedbackResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.GetSampleDataRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.GetSampleDataResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAlertsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAlertsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyDetectorsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyDetectorsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListMetricSetsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListMetricSetsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.PutFeedbackRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.PutFeedbackResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.TagResourceRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.TagResourceResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.UntagResourceRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.UntagResourceResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateAlertRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateAlertResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateAnomalyDetectorRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateMetricSetRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.UpdateMetricSetResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "LookoutMetrics"
public const val SdkVersion: String = "1.0.69"
public const val ServiceApiVersion: String = "2017-07-25"

/**
 * This is the *Amazon Lookout for Metrics API Reference*. For an introduction to the service with tutorials for getting started, visit [Amazon Lookout for Metrics Developer Guide](https://docs.aws.amazon.com/lookoutmetrics/latest/dev).
 */
public interface LookoutMetricsClient : SdkClient {
    /**
     * LookoutMetricsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LookoutMetricsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "LookoutMetrics",
                "LOOKOUTMETRICS",
                "lookoutmetrics",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LookoutMetricsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LookoutMetricsClient = DefaultLookoutMetricsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LookoutMetricsEndpointProvider = builder.endpointProvider ?: DefaultLookoutMetricsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LookoutMetricsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLookoutMetricsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "LookoutMetrics"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LookoutMetricsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LookoutMetricsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Activates an anomaly detector.
     */
    public suspend fun activateAnomalyDetector(input: ActivateAnomalyDetectorRequest): ActivateAnomalyDetectorResponse

    /**
     * Runs a backtest for anomaly detection for the specified resource.
     */
    public suspend fun backTestAnomalyDetector(input: BackTestAnomalyDetectorRequest): BackTestAnomalyDetectorResponse

    /**
     * Creates an alert for an anomaly detector.
     */
    public suspend fun createAlert(input: CreateAlertRequest): CreateAlertResponse

    /**
     * Creates an anomaly detector.
     */
    public suspend fun createAnomalyDetector(input: CreateAnomalyDetectorRequest): CreateAnomalyDetectorResponse

    /**
     * Creates a dataset.
     */
    public suspend fun createMetricSet(input: CreateMetricSetRequest): CreateMetricSetResponse

    /**
     * Deactivates an anomaly detector.
     */
    public suspend fun deactivateAnomalyDetector(input: DeactivateAnomalyDetectorRequest): DeactivateAnomalyDetectorResponse

    /**
     * Deletes an alert.
     */
    public suspend fun deleteAlert(input: DeleteAlertRequest): DeleteAlertResponse

    /**
     * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any configured datasets and alerts.
     */
    public suspend fun deleteAnomalyDetector(input: DeleteAnomalyDetectorRequest): DeleteAnomalyDetectorResponse

    /**
     * Describes an alert.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun describeAlert(input: DescribeAlertRequest): DescribeAlertResponse

    /**
     * Returns information about the status of the specified anomaly detection jobs.
     */
    public suspend fun describeAnomalyDetectionExecutions(input: DescribeAnomalyDetectionExecutionsRequest): DescribeAnomalyDetectionExecutionsResponse

    /**
     * Describes a detector.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun describeAnomalyDetector(input: DescribeAnomalyDetectorRequest): DescribeAnomalyDetectorResponse

    /**
     * Describes a dataset.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun describeMetricSet(input: DescribeMetricSetRequest): DescribeMetricSetResponse

    /**
     * Detects an Amazon S3 dataset's file format, interval, and offset.
     */
    public suspend fun detectMetricSetConfig(input: DetectMetricSetConfigRequest): DetectMetricSetConfigResponse

    /**
     * Returns details about a group of anomalous metrics.
     */
    public suspend fun getAnomalyGroup(input: GetAnomalyGroupRequest): GetAnomalyGroupResponse

    /**
     * Returns details about the requested data quality metrics.
     */
    public suspend fun getDataQualityMetrics(input: GetDataQualityMetricsRequest): GetDataQualityMetricsResponse

    /**
     * Get feedback for an anomaly group.
     */
    public suspend fun getFeedback(input: GetFeedbackRequest): GetFeedbackResponse

    /**
     * Returns a selection of sample records from an Amazon S3 datasource.
     */
    public suspend fun getSampleData(input: GetSampleDataRequest = GetSampleDataRequest { }): GetSampleDataResponse

    /**
     * Lists the alerts attached to a detector.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun listAlerts(input: ListAlertsRequest = ListAlertsRequest { }): ListAlertsResponse

    /**
     * Lists the detectors in the current AWS Region.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun listAnomalyDetectors(input: ListAnomalyDetectorsRequest = ListAnomalyDetectorsRequest { }): ListAnomalyDetectorsResponse

    /**
     * Returns a list of measures that are potential causes or effects of an anomaly group.
     */
    public suspend fun listAnomalyGroupRelatedMetrics(input: ListAnomalyGroupRelatedMetricsRequest): ListAnomalyGroupRelatedMetricsResponse

    /**
     * Returns a list of anomaly groups.
     */
    public suspend fun listAnomalyGroupSummaries(input: ListAnomalyGroupSummariesRequest): ListAnomalyGroupSummariesResponse

    /**
     * Gets a list of anomalous metrics for a measure in an anomaly group.
     */
    public suspend fun listAnomalyGroupTimeSeries(input: ListAnomalyGroupTimeSeriesRequest): ListAnomalyGroupTimeSeriesResponse

    /**
     * Lists the datasets in the current AWS Region.
     *
     * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
     */
    public suspend fun listMetricSets(input: ListMetricSetsRequest = ListMetricSetsRequest { }): ListMetricSetsResponse

    /**
     * Gets a list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) for a detector, dataset, or alert.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Add feedback for an anomalous metric.
     */
    public suspend fun putFeedback(input: PutFeedbackRequest): PutFeedbackResponse

    /**
     * Adds [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to a detector, dataset, or alert.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) from a detector, dataset, or alert.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Make changes to an existing alert.
     */
    public suspend fun updateAlert(input: UpdateAlertRequest): UpdateAlertResponse

    /**
     * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
     */
    public suspend fun updateAnomalyDetector(input: UpdateAnomalyDetectorRequest): UpdateAnomalyDetectorResponse

    /**
     * Updates a dataset.
     */
    public suspend fun updateMetricSet(input: UpdateMetricSetRequest): UpdateMetricSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LookoutMetricsClient.withConfig(block: LookoutMetricsClient.Config.Builder.() -> Unit): LookoutMetricsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLookoutMetricsClient(newConfig)
}

/**
 * Activates an anomaly detector.
 */
public suspend inline fun LookoutMetricsClient.activateAnomalyDetector(crossinline block: ActivateAnomalyDetectorRequest.Builder.() -> Unit): ActivateAnomalyDetectorResponse = activateAnomalyDetector(ActivateAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Runs a backtest for anomaly detection for the specified resource.
 */
public suspend inline fun LookoutMetricsClient.backTestAnomalyDetector(crossinline block: BackTestAnomalyDetectorRequest.Builder.() -> Unit): BackTestAnomalyDetectorResponse = backTestAnomalyDetector(BackTestAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Creates an alert for an anomaly detector.
 */
public suspend inline fun LookoutMetricsClient.createAlert(crossinline block: CreateAlertRequest.Builder.() -> Unit): CreateAlertResponse = createAlert(CreateAlertRequest.Builder().apply(block).build())

/**
 * Creates an anomaly detector.
 */
public suspend inline fun LookoutMetricsClient.createAnomalyDetector(crossinline block: CreateAnomalyDetectorRequest.Builder.() -> Unit): CreateAnomalyDetectorResponse = createAnomalyDetector(CreateAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Creates a dataset.
 */
public suspend inline fun LookoutMetricsClient.createMetricSet(crossinline block: CreateMetricSetRequest.Builder.() -> Unit): CreateMetricSetResponse = createMetricSet(CreateMetricSetRequest.Builder().apply(block).build())

/**
 * Deactivates an anomaly detector.
 */
public suspend inline fun LookoutMetricsClient.deactivateAnomalyDetector(crossinline block: DeactivateAnomalyDetectorRequest.Builder.() -> Unit): DeactivateAnomalyDetectorResponse = deactivateAnomalyDetector(DeactivateAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Deletes an alert.
 */
public suspend inline fun LookoutMetricsClient.deleteAlert(crossinline block: DeleteAlertRequest.Builder.() -> Unit): DeleteAlertResponse = deleteAlert(DeleteAlertRequest.Builder().apply(block).build())

/**
 * Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any configured datasets and alerts.
 */
public suspend inline fun LookoutMetricsClient.deleteAnomalyDetector(crossinline block: DeleteAnomalyDetectorRequest.Builder.() -> Unit): DeleteAnomalyDetectorResponse = deleteAnomalyDetector(DeleteAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Describes an alert.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.describeAlert(crossinline block: DescribeAlertRequest.Builder.() -> Unit): DescribeAlertResponse = describeAlert(DescribeAlertRequest.Builder().apply(block).build())

/**
 * Returns information about the status of the specified anomaly detection jobs.
 */
public suspend inline fun LookoutMetricsClient.describeAnomalyDetectionExecutions(crossinline block: DescribeAnomalyDetectionExecutionsRequest.Builder.() -> Unit): DescribeAnomalyDetectionExecutionsResponse = describeAnomalyDetectionExecutions(DescribeAnomalyDetectionExecutionsRequest.Builder().apply(block).build())

/**
 * Describes a detector.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.describeAnomalyDetector(crossinline block: DescribeAnomalyDetectorRequest.Builder.() -> Unit): DescribeAnomalyDetectorResponse = describeAnomalyDetector(DescribeAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Describes a dataset.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.describeMetricSet(crossinline block: DescribeMetricSetRequest.Builder.() -> Unit): DescribeMetricSetResponse = describeMetricSet(DescribeMetricSetRequest.Builder().apply(block).build())

/**
 * Detects an Amazon S3 dataset's file format, interval, and offset.
 */
public suspend inline fun LookoutMetricsClient.detectMetricSetConfig(crossinline block: DetectMetricSetConfigRequest.Builder.() -> Unit): DetectMetricSetConfigResponse = detectMetricSetConfig(DetectMetricSetConfigRequest.Builder().apply(block).build())

/**
 * Returns details about a group of anomalous metrics.
 */
public suspend inline fun LookoutMetricsClient.getAnomalyGroup(crossinline block: GetAnomalyGroupRequest.Builder.() -> Unit): GetAnomalyGroupResponse = getAnomalyGroup(GetAnomalyGroupRequest.Builder().apply(block).build())

/**
 * Returns details about the requested data quality metrics.
 */
public suspend inline fun LookoutMetricsClient.getDataQualityMetrics(crossinline block: GetDataQualityMetricsRequest.Builder.() -> Unit): GetDataQualityMetricsResponse = getDataQualityMetrics(GetDataQualityMetricsRequest.Builder().apply(block).build())

/**
 * Get feedback for an anomaly group.
 */
public suspend inline fun LookoutMetricsClient.getFeedback(crossinline block: GetFeedbackRequest.Builder.() -> Unit): GetFeedbackResponse = getFeedback(GetFeedbackRequest.Builder().apply(block).build())

/**
 * Returns a selection of sample records from an Amazon S3 datasource.
 */
public suspend inline fun LookoutMetricsClient.getSampleData(crossinline block: GetSampleDataRequest.Builder.() -> Unit): GetSampleDataResponse = getSampleData(GetSampleDataRequest.Builder().apply(block).build())

/**
 * Lists the alerts attached to a detector.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.listAlerts(crossinline block: ListAlertsRequest.Builder.() -> Unit): ListAlertsResponse = listAlerts(ListAlertsRequest.Builder().apply(block).build())

/**
 * Lists the detectors in the current AWS Region.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.listAnomalyDetectors(crossinline block: ListAnomalyDetectorsRequest.Builder.() -> Unit): ListAnomalyDetectorsResponse = listAnomalyDetectors(ListAnomalyDetectorsRequest.Builder().apply(block).build())

/**
 * Returns a list of measures that are potential causes or effects of an anomaly group.
 */
public suspend inline fun LookoutMetricsClient.listAnomalyGroupRelatedMetrics(crossinline block: ListAnomalyGroupRelatedMetricsRequest.Builder.() -> Unit): ListAnomalyGroupRelatedMetricsResponse = listAnomalyGroupRelatedMetrics(ListAnomalyGroupRelatedMetricsRequest.Builder().apply(block).build())

/**
 * Returns a list of anomaly groups.
 */
public suspend inline fun LookoutMetricsClient.listAnomalyGroupSummaries(crossinline block: ListAnomalyGroupSummariesRequest.Builder.() -> Unit): ListAnomalyGroupSummariesResponse = listAnomalyGroupSummaries(ListAnomalyGroupSummariesRequest.Builder().apply(block).build())

/**
 * Gets a list of anomalous metrics for a measure in an anomaly group.
 */
public suspend inline fun LookoutMetricsClient.listAnomalyGroupTimeSeries(crossinline block: ListAnomalyGroupTimeSeriesRequest.Builder.() -> Unit): ListAnomalyGroupTimeSeriesResponse = listAnomalyGroupTimeSeries(ListAnomalyGroupTimeSeriesRequest.Builder().apply(block).build())

/**
 * Lists the datasets in the current AWS Region.
 *
 * Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.
 */
public suspend inline fun LookoutMetricsClient.listMetricSets(crossinline block: ListMetricSetsRequest.Builder.() -> Unit): ListMetricSetsResponse = listMetricSets(ListMetricSetsRequest.Builder().apply(block).build())

/**
 * Gets a list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) for a detector, dataset, or alert.
 */
public suspend inline fun LookoutMetricsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Add feedback for an anomalous metric.
 */
public suspend inline fun LookoutMetricsClient.putFeedback(crossinline block: PutFeedbackRequest.Builder.() -> Unit): PutFeedbackResponse = putFeedback(PutFeedbackRequest.Builder().apply(block).build())

/**
 * Adds [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to a detector, dataset, or alert.
 */
public suspend inline fun LookoutMetricsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) from a detector, dataset, or alert.
 */
public suspend inline fun LookoutMetricsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Make changes to an existing alert.
 */
public suspend inline fun LookoutMetricsClient.updateAlert(crossinline block: UpdateAlertRequest.Builder.() -> Unit): UpdateAlertResponse = updateAlert(UpdateAlertRequest.Builder().apply(block).build())

/**
 * Updates a detector. After activation, you can only change a detector's ingestion delay and description.
 */
public suspend inline fun LookoutMetricsClient.updateAnomalyDetector(crossinline block: UpdateAnomalyDetectorRequest.Builder.() -> Unit): UpdateAnomalyDetectorResponse = updateAnomalyDetector(UpdateAnomalyDetectorRequest.Builder().apply(block).build())

/**
 * Updates a dataset.
 */
public suspend inline fun LookoutMetricsClient.updateMetricSet(crossinline block: UpdateMetricSetRequest.Builder.() -> Unit): UpdateMetricSetResponse = updateMetricSet(UpdateMetricSetRequest.Builder().apply(block).build())
