// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.paginators

import aws.sdk.kotlin.services.lookoutmetrics.LookoutMetricsClient
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectionExecutionsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.GetFeedbackRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.GetFeedbackResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAlertsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAlertsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyDetectorsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyDetectorsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupRelatedMetricsResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupTimeSeriesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.ListMetricSetsRequest
import aws.sdk.kotlin.services.lookoutmetrics.model.ListMetricSetsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeAnomalyDetectionExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAnomalyDetectionExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAnomalyDetectionExecutionsResponse]
 */
public fun LookoutMetricsClient.describeAnomalyDetectionExecutionsPaginated(initialRequest: DescribeAnomalyDetectionExecutionsRequest): Flow<DescribeAnomalyDetectionExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAnomalyDetectionExecutionsPaginated.describeAnomalyDetectionExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAnomalyDetectionExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAnomalyDetectionExecutionsResponse]
 */
public fun LookoutMetricsClient.describeAnomalyDetectionExecutionsPaginated(block: DescribeAnomalyDetectionExecutionsRequest.Builder.() -> Unit): Flow<DescribeAnomalyDetectionExecutionsResponse> =
    describeAnomalyDetectionExecutionsPaginated(DescribeAnomalyDetectionExecutionsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetFeedbackResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFeedbackRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFeedbackResponse]
 */
public fun LookoutMetricsClient.getFeedbackPaginated(initialRequest: GetFeedbackRequest): Flow<GetFeedbackResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFeedbackPaginated.getFeedback(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFeedbackResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFeedbackResponse]
 */
public fun LookoutMetricsClient.getFeedbackPaginated(block: GetFeedbackRequest.Builder.() -> Unit): Flow<GetFeedbackResponse> =
    getFeedbackPaginated(GetFeedbackRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAlertsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun LookoutMetricsClient.listAlertsPaginated(initialRequest: ListAlertsRequest = ListAlertsRequest { }): Flow<ListAlertsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAlertsPaginated.listAlerts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAlertsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAlertsResponse]
 */
public fun LookoutMetricsClient.listAlertsPaginated(block: ListAlertsRequest.Builder.() -> Unit): Flow<ListAlertsResponse> =
    listAlertsPaginated(ListAlertsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAnomalyDetectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomalyDetectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyDetectorsResponse]
 */
public fun LookoutMetricsClient.listAnomalyDetectorsPaginated(initialRequest: ListAnomalyDetectorsRequest = ListAnomalyDetectorsRequest { }): Flow<ListAnomalyDetectorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomalyDetectorsPaginated.listAnomalyDetectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomalyDetectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyDetectorsResponse]
 */
public fun LookoutMetricsClient.listAnomalyDetectorsPaginated(block: ListAnomalyDetectorsRequest.Builder.() -> Unit): Flow<ListAnomalyDetectorsResponse> =
    listAnomalyDetectorsPaginated(ListAnomalyDetectorsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAnomalyGroupRelatedMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomalyGroupRelatedMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupRelatedMetricsResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupRelatedMetricsPaginated(initialRequest: ListAnomalyGroupRelatedMetricsRequest): Flow<ListAnomalyGroupRelatedMetricsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomalyGroupRelatedMetricsPaginated.listAnomalyGroupRelatedMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomalyGroupRelatedMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupRelatedMetricsResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupRelatedMetricsPaginated(block: ListAnomalyGroupRelatedMetricsRequest.Builder.() -> Unit): Flow<ListAnomalyGroupRelatedMetricsResponse> =
    listAnomalyGroupRelatedMetricsPaginated(ListAnomalyGroupRelatedMetricsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAnomalyGroupSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomalyGroupSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupSummariesResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupSummariesPaginated(initialRequest: ListAnomalyGroupSummariesRequest): Flow<ListAnomalyGroupSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomalyGroupSummariesPaginated.listAnomalyGroupSummaries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomalyGroupSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupSummariesResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupSummariesPaginated(block: ListAnomalyGroupSummariesRequest.Builder.() -> Unit): Flow<ListAnomalyGroupSummariesResponse> =
    listAnomalyGroupSummariesPaginated(ListAnomalyGroupSummariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAnomalyGroupTimeSeriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnomalyGroupTimeSeriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupTimeSeriesResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupTimeSeriesPaginated(initialRequest: ListAnomalyGroupTimeSeriesRequest): Flow<ListAnomalyGroupTimeSeriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnomalyGroupTimeSeriesPaginated.listAnomalyGroupTimeSeries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnomalyGroupTimeSeriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnomalyGroupTimeSeriesResponse]
 */
public fun LookoutMetricsClient.listAnomalyGroupTimeSeriesPaginated(block: ListAnomalyGroupTimeSeriesRequest.Builder.() -> Unit): Flow<ListAnomalyGroupTimeSeriesResponse> =
    listAnomalyGroupTimeSeriesPaginated(ListAnomalyGroupTimeSeriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMetricSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMetricSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricSetsResponse]
 */
public fun LookoutMetricsClient.listMetricSetsPaginated(initialRequest: ListMetricSetsRequest = ListMetricSetsRequest { }): Flow<ListMetricSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMetricSetsPaginated.listMetricSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMetricSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMetricSetsResponse]
 */
public fun LookoutMetricsClient.listMetricSetsPaginated(block: ListMetricSetsRequest.Builder.() -> Unit): Flow<ListMetricSetsResponse> =
    listMetricSetsPaginated(ListMetricSetsRequest.Builder().apply(block).build())
