// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.serde

import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyGroupStatistics
import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyGroupSummary
import aws.sdk.kotlin.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.LookoutMetricsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAnomalyGroupSummariesOperationDeserializer: HttpDeserialize<ListAnomalyGroupSummariesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListAnomalyGroupSummariesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAnomalyGroupSummariesError(context, call)
        }
        val builder = ListAnomalyGroupSummariesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAnomalyGroupSummariesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListAnomalyGroupSummariesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LookoutMetricsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LookoutMetricsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAnomalyGroupSummariesOperationBody(builder: ListAnomalyGroupSummariesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYGROUPSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AnomalyGroupStatistics"))
    val ANOMALYGROUPSUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AnomalyGroupSummaryList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYGROUPSTATISTICS_DESCRIPTOR)
        field(ANOMALYGROUPSUMMARYLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYGROUPSTATISTICS_DESCRIPTOR.index -> builder.anomalyGroupStatistics = deserializeAnomalyGroupStatisticsDocument(deserializer)
                ANOMALYGROUPSUMMARYLIST_DESCRIPTOR.index -> builder.anomalyGroupSummaryList =
                    deserializer.deserializeList(ANOMALYGROUPSUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<AnomalyGroupSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalyGroupSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
