// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.serde

import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyDetectorConfigSummary
import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyDetectorFailureType
import aws.sdk.kotlin.services.lookoutmetrics.model.AnomalyDetectorStatus
import aws.sdk.kotlin.services.lookoutmetrics.model.DescribeAnomalyDetectorResponse
import aws.sdk.kotlin.services.lookoutmetrics.model.LookoutMetricsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAnomalyDetectorOperationDeserializer: HttpDeserialize<DescribeAnomalyDetectorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAnomalyDetectorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAnomalyDetectorError(context, call)
        }
        val builder = DescribeAnomalyDetectorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAnomalyDetectorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeAnomalyDetectorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LookoutMetricsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LookoutMetricsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAnomalyDetectorOperationBody(builder: DescribeAnomalyDetectorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALYDETECTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnomalyDetectorArn"))
    val ANOMALYDETECTORCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AnomalyDetectorConfig"))
    val ANOMALYDETECTORDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnomalyDetectorDescription"))
    val ANOMALYDETECTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnomalyDetectorName"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val FAILURETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FailureType"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALYDETECTORARN_DESCRIPTOR)
        field(ANOMALYDETECTORCONFIG_DESCRIPTOR)
        field(ANOMALYDETECTORDESCRIPTION_DESCRIPTOR)
        field(ANOMALYDETECTORNAME_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FAILURETYPE_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALYDETECTORARN_DESCRIPTOR.index -> builder.anomalyDetectorArn = deserializeString()
                ANOMALYDETECTORCONFIG_DESCRIPTOR.index -> builder.anomalyDetectorConfig = deserializeAnomalyDetectorConfigSummaryDocument(deserializer)
                ANOMALYDETECTORDESCRIPTION_DESCRIPTOR.index -> builder.anomalyDetectorDescription = deserializeString()
                ANOMALYDETECTORNAME_DESCRIPTOR.index -> builder.anomalyDetectorName = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FAILURETYPE_DESCRIPTOR.index -> builder.failureType = deserializeString().let { AnomalyDetectorFailureType.fromValue(it) }
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AnomalyDetectorStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
