// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model



/**
 * Contains information about the SNS topic to which you want to send your alerts and the IAM role that has access to that topic.
 */
public class SnsConfiguration private constructor(builder: Builder) {
    /**
     * The ARN of the IAM role that has access to the target SNS topic.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The format of the SNS topic.
     * + `JSON` – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the default.
     * + `LONG_TEXT` – Send human-readable alerts with information about the impacted timeseries and a link to the anomaly detail page. We recommend this for email.
     * + `SHORT_TEXT` – Send human-readable alerts with a link to the anomaly detail page. We recommend this for SMS.
     */
    public val snsFormat: aws.sdk.kotlin.services.lookoutmetrics.model.SnsFormat? = builder.snsFormat
    /**
     * The ARN of the target SNS topic.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.SnsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnsConfiguration(")
        append("roleArn=$roleArn,")
        append("snsFormat=$snsFormat,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (snsFormat?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnsConfiguration

        if (roleArn != other.roleArn) return false
        if (snsFormat != other.snsFormat) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.SnsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the IAM role that has access to the target SNS topic.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The format of the SNS topic.
         * + `JSON` – Send JSON alerts with an anomaly ID and a link to the anomaly detail page. This is the default.
         * + `LONG_TEXT` – Send human-readable alerts with information about the impacted timeseries and a link to the anomaly detail page. We recommend this for email.
         * + `SHORT_TEXT` – Send human-readable alerts with a link to the anomaly detail page. We recommend this for SMS.
         */
        public var snsFormat: aws.sdk.kotlin.services.lookoutmetrics.model.SnsFormat? = null
        /**
         * The ARN of the target SNS topic.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.SnsConfiguration) : this() {
            this.roleArn = x.roleArn
            this.snsFormat = x.snsFormat
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.SnsConfiguration = SnsConfiguration(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (snsTopicArn == null) snsTopicArn = ""
            return this
        }
    }
}
