// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lookoutmetrics.model



public class CreateMetricSetRequest private constructor(builder: Builder) {
    /**
     * The ARN of the anomaly detector that will use the dataset.
     */
    public val anomalyDetectorArn: kotlin.String? = builder.anomalyDetectorArn
    /**
     * A list of filters that specify which data is kept for anomaly detection.
     */
    public val dimensionFilterList: List<MetricSetDimensionFilter>? = builder.dimensionFilterList
    /**
     * A list of the fields you want to treat as dimensions.
     */
    public val dimensionList: List<String>? = builder.dimensionList
    /**
     * A list of metrics that the dataset will contain.
     */
    public val metricList: List<Metric>? = builder.metricList
    /**
     * A description of the dataset you are creating.
     */
    public val metricSetDescription: kotlin.String? = builder.metricSetDescription
    /**
     * The frequency with which the source data will be analyzed for anomalies.
     */
    public val metricSetFrequency: aws.sdk.kotlin.services.lookoutmetrics.model.Frequency? = builder.metricSetFrequency
    /**
     * The name of the dataset.
     */
    public val metricSetName: kotlin.String? = builder.metricSetName
    /**
     * Contains information about how the source data should be interpreted.
     */
    public val metricSource: aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource? = builder.metricSource
    /**
     * After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3, Redshift, Athena and datasources.
     */
    public val offset: kotlin.Int? = builder.offset
    /**
     * A list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to apply to the dataset.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Contains information about the column used for tracking time in your source data.
     */
    public val timestampColumn: aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn? = builder.timestampColumn
    /**
     * The time zone in which your source data was recorded.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMetricSetRequest(")
        append("anomalyDetectorArn=$anomalyDetectorArn,")
        append("dimensionFilterList=$dimensionFilterList,")
        append("dimensionList=$dimensionList,")
        append("metricList=$metricList,")
        append("metricSetDescription=$metricSetDescription,")
        append("metricSetFrequency=$metricSetFrequency,")
        append("metricSetName=$metricSetName,")
        append("metricSource=$metricSource,")
        append("offset=$offset,")
        append("tags=$tags,")
        append("timestampColumn=$timestampColumn,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyDetectorArn?.hashCode() ?: 0
        result = 31 * result + (dimensionFilterList?.hashCode() ?: 0)
        result = 31 * result + (dimensionList?.hashCode() ?: 0)
        result = 31 * result + (metricList?.hashCode() ?: 0)
        result = 31 * result + (metricSetDescription?.hashCode() ?: 0)
        result = 31 * result + (metricSetFrequency?.hashCode() ?: 0)
        result = 31 * result + (metricSetName?.hashCode() ?: 0)
        result = 31 * result + (metricSource?.hashCode() ?: 0)
        result = 31 * result + (offset ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timestampColumn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMetricSetRequest

        if (anomalyDetectorArn != other.anomalyDetectorArn) return false
        if (dimensionFilterList != other.dimensionFilterList) return false
        if (dimensionList != other.dimensionList) return false
        if (metricList != other.metricList) return false
        if (metricSetDescription != other.metricSetDescription) return false
        if (metricSetFrequency != other.metricSetFrequency) return false
        if (metricSetName != other.metricSetName) return false
        if (metricSource != other.metricSource) return false
        if (offset != other.offset) return false
        if (tags != other.tags) return false
        if (timestampColumn != other.timestampColumn) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the anomaly detector that will use the dataset.
         */
        public var anomalyDetectorArn: kotlin.String? = null
        /**
         * A list of filters that specify which data is kept for anomaly detection.
         */
        public var dimensionFilterList: List<MetricSetDimensionFilter>? = null
        /**
         * A list of the fields you want to treat as dimensions.
         */
        public var dimensionList: List<String>? = null
        /**
         * A list of metrics that the dataset will contain.
         */
        public var metricList: List<Metric>? = null
        /**
         * A description of the dataset you are creating.
         */
        public var metricSetDescription: kotlin.String? = null
        /**
         * The frequency with which the source data will be analyzed for anomalies.
         */
        public var metricSetFrequency: aws.sdk.kotlin.services.lookoutmetrics.model.Frequency? = null
        /**
         * The name of the dataset.
         */
        public var metricSetName: kotlin.String? = null
        /**
         * Contains information about how the source data should be interpreted.
         */
        public var metricSource: aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource? = null
        /**
         * After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3, Redshift, Athena and datasources.
         */
        public var offset: kotlin.Int? = null
        /**
         * A list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to apply to the dataset.
         */
        public var tags: Map<String, String>? = null
        /**
         * Contains information about the column used for tracking time in your source data.
         */
        public var timestampColumn: aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn? = null
        /**
         * The time zone in which your source data was recorded.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetRequest) : this() {
            this.anomalyDetectorArn = x.anomalyDetectorArn
            this.dimensionFilterList = x.dimensionFilterList
            this.dimensionList = x.dimensionList
            this.metricList = x.metricList
            this.metricSetDescription = x.metricSetDescription
            this.metricSetFrequency = x.metricSetFrequency
            this.metricSetName = x.metricSetName
            this.metricSource = x.metricSource
            this.offset = x.offset
            this.tags = x.tags
            this.timestampColumn = x.timestampColumn
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lookoutmetrics.model.CreateMetricSetRequest = CreateMetricSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource] inside the given [block]
         */
        public fun metricSource(block: aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource.Builder.() -> kotlin.Unit) {
            this.metricSource = aws.sdk.kotlin.services.lookoutmetrics.model.MetricSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn] inside the given [block]
         */
        public fun timestampColumn(block: aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn.Builder.() -> kotlin.Unit) {
            this.timestampColumn = aws.sdk.kotlin.services.lookoutmetrics.model.TimestampColumn.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (anomalyDetectorArn == null) anomalyDetectorArn = ""
            if (metricList == null) metricList = emptyList()
            if (metricSetName == null) metricSetName = ""
            if (metricSource == null) metricSource = MetricSource.Builder().correctErrors().build()
            return this
        }
    }
}
